/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityDeconstructor
extends TileBaseElectricBlock
implements IInventoryDefaults,
ISidedInventory,
IMachineSides {
    public static final float SALVAGE_CHANCE = 0.75f;
    public static final int PROCESS_TIME_REQUIRED_BASE = 250;
    public int processTimeRequired = 250;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = null;
    private long ticks;
    private ItemStack[] containingItems = new ItemStack[11];
    public static List<ItemStack> salvageable = new LinkedList<ItemStack>();
    public static List<INasaWorkbenchRecipe> knownRecipes = new LinkedList<INasaWorkbenchRecipe>();
    private int recursiveCount;
    private IMachineSides.MachineSidePack[] machineSides;

    private static void initialiseItemList() {
        if (GalacticraftCore.isPlanetsLoaded) {
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidsItems.basicItem, 1, 5));
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidsItems.basicItem, 1, 6));
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidsItems.basicItem, 1, 0));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 3));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 5));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 2));
        }
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.flagPole));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.heavyPlatingTier1));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.itemBasicMoon, 1, 1));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.itemBasicMoon, 1, 0));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 9));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 10));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 6));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 7));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 8));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 11));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 3));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 4));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 5));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151042_j));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151043_k));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151074_bl));
    }

    public static void initialiseRecipeList() {
        knownRecipes.addAll(GalacticraftRegistry.getRocketT1Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getBuggyBenchRecipes());
    }

    public static void initialiseRecipeListPlanets() {
        knownRecipes.addAll(GalacticraftRegistry.getRocketT2Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getCargoRocketRecipes());
        knownRecipes.addAll(GalacticraftRegistry.getRocketT3Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getAstroMinerRecipes());
    }

    public TileEntityDeconstructor() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(2);
    }

    public static void addSalvage(ItemStack itemStack) {
        for (ItemStack inList : salvageable) {
            if (!ItemStack.func_179545_c((ItemStack)inList, (ItemStack)itemStack)) continue;
            return;
        }
        salvageable.add(itemStack.func_77946_l());
    }

    public static boolean isSalvage(ItemStack stack) {
        for (ItemStack inList : salvageable) {
            if (!ItemStack.func_179545_c((ItemStack)inList, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canDeconstruct()) {
                    ++this.processTicks;
                    if (this.processTicks * 5 % this.processTimeRequired == 5) {
                        this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), "random.anvil_break", 0.25f, 0.4f);
                    }
                    if (this.processTicks >= this.processTimeRequired) {
                        this.processTicks = 0;
                        this.deconstruct();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    private boolean canDeconstruct() {
        return this.containingItems[1] != null;
    }

    public void deconstruct() {
        LinkedList<ItemStack> ingredients = new LinkedList<ItemStack>();
        ingredients.add(new ItemStack(this.containingItems[1].func_77973_b(), 1, this.containingItems[1].func_77952_i()));
        this.recursiveCount = 0;
        List<ItemStack> salvaged = this.getSalvageable(ingredients);
        salvaged = this.squashList(salvaged);
        salvaged = this.randomChanceList(salvaged);
        if (salvaged != null) {
            for (ItemStack output : salvaged) {
                this.addToOutputMatrix(output);
            }
        }
        this.func_70298_a(1, 1);
    }

    private List<ItemStack> getSalvageable(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        if (this.recursiveCount++ > 10) {
            this.recursiveCount = 0;
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            if (TileEntityDeconstructor.isSalvage(stack)) {
                ret.add(stack);
                continue;
            }
            GCLog.debug("Trying to " + this.recursiveCount + " break down " + stack.toString());
            List<ItemStack> ingredients2 = this.getIngredients(stack);
            List<ItemStack> recursive = this.getSalvageable(ingredients2);
            if (recursive == null || recursive.isEmpty()) continue;
            ret.addAll(recursive);
        }
        --this.recursiveCount;
        return ret;
    }

    private List<ItemStack> squashList(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            boolean matched = false;
            for (ItemStack stack1 : ret) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stack1)) continue;
                matched = true;
                stack1.field_77994_a += stack.field_77994_a;
                break;
            }
            if (matched) continue;
            ret.add(stack);
        }
        return ret;
    }

    private List<ItemStack> randomChanceList(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            int count = stack.field_77994_a;
            int result = 0;
            for (int i = 0; i < count; ++i) {
                if (!(this.field_145850_b.field_73012_v.nextFloat() < 0.75f)) continue;
                ++result;
            }
            if (result <= 0) continue;
            stack.field_77994_a = result;
            ret.add(stack);
        }
        return ret;
    }

    private List<ItemStack> getIngredients(ItemStack stack) {
        for (INasaWorkbenchRecipe recipe : knownRecipes) {
            ItemStack test = recipe.getRecipeOutput();
            if (!ItemStack.func_179545_c((ItemStack)test, (ItemStack)stack) || test.field_77994_a != 1) continue;
            return this.toItemStackList(recipe.getRecipeInput().values());
        }
        List standardRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : standardRecipes) {
            ItemStack test = recipe.func_77571_b();
            if (!ItemStack.func_179545_c((ItemStack)test, (ItemStack)stack) || test.field_77994_a != 1) continue;
            if (recipe instanceof ShapedRecipes) {
                return this.expandRecipeInputs(Arrays.asList(((ShapedRecipes)recipe).field_77574_d));
            }
            if (recipe instanceof ShapelessRecipes) {
                return this.expandRecipeInputs(Arrays.asList(((ShapelessRecipes)recipe).field_77579_b));
            }
            if (recipe instanceof ShapedOreRecipe) {
                return this.expandRecipeInputs(Arrays.asList(((ShapedOreRecipe)recipe).getInput()));
            }
            if (!(recipe instanceof ShapelessOreRecipe)) continue;
            return this.expandRecipeInputs(Arrays.asList(((ShapelessOreRecipe)recipe).getInput()));
        }
        return null;
    }

    private List<ItemStack> expandRecipeInputs(List<?> inputs) {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (Object input : inputs) {
            ItemStack toAdd = this.parseRecipeInput(input);
            if (toAdd == null) continue;
            ret.add(toAdd);
        }
        return ret;
    }

    private ItemStack parseRecipeInput(Object input) {
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                return new ItemStack(stack.func_77973_b(), stack.field_77994_a, 0);
            }
            return stack.func_77946_l();
        }
        if (input instanceof String) {
            List stacks = OreDictionary.getOres((String)((String)input));
            if (stacks.isEmpty()) {
                return null;
            }
            Iterator iterator = stacks.iterator();
            if (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (TileEntityDeconstructor.isSalvage(stack)) {
                    // empty if block
                }
                return stack.func_77946_l();
            }
            return stacks.get(0) == null ? null : ((ItemStack)stacks.get(0)).func_77946_l();
        }
        if (input instanceof Iterable) {
            for (Object obj : (Iterable)input) {
                ItemStack ret = this.parseRecipeInput(obj);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private List<ItemStack> toItemStackList(Collection<ItemStack> inputs) {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack o : inputs) {
            if (o == null) continue;
            ret.add(o.func_77946_l());
        }
        return ret;
    }

    private void addToOutputMatrix(ItemStack stack) {
        for (int i = 2; i < 11; ++i) {
            if (this.containingItems[i] == null) {
                this.containingItems[i] = stack;
                return;
            }
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.containingItems[i])) continue;
            int size = this.containingItems[i].field_77994_a;
            if (size + stack.field_77994_a < this.func_70297_j_()) {
                this.containingItems[i].field_77994_a += stack.field_77994_a;
                return;
            }
            this.containingItems[i].field_77994_a = this.func_70297_j_();
            stack.field_77994_a -= this.func_70297_j_() - size;
        }
        GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
        this.addMachineSidesToNBT(par1NBTTagCompound);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.containingItems.length) {
            return null;
        }
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.containingItems.length) {
            return null;
        }
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 < this.containingItems.length) {
            this.containingItems[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
                par2ItemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine2.10.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityplayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        return slotID == 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        }
        return new int[]{1};
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID >= 2;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachine2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachine2.FACING);
        }
        return EnumFacing.NORTH;
    }

    public ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }

    static {
        TileEntityDeconstructor.initialiseItemList();
    }
}

