/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityCrafting
extends TileEntity
implements IInventoryDefaults,
ISidedInventory {
    private static final int SIZEINVENTORY = 9;
    public PersistantInventoryCrafting craftMatrix = new PersistantInventoryCrafting();
    public ItemStack[] memory = new ItemStack[9];

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamicInventory(this));
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void updateMemory() {
        if (CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w()) == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack == null) {
                this.memory[i] = null;
                continue;
            }
            ItemStack stack2 = stack.func_77946_l();
            stack2.field_77994_a = 0;
            this.memory[i] = stack2;
        }
    }

    public ItemStack getMemory(int i) {
        return this.memory[i];
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 < 9) {
            return this.craftMatrix.func_70301_a(par1);
        }
        try {
            return CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ItemStack func_70298_a(int par1, int par2) {
        ItemStack craftingResult;
        if (par1 >= 0 && par1 < 9) {
            ItemStack result = this.craftMatrix.func_70298_a(par1, par2);
            return result;
        }
        if (par1 == 9 && this.stillMatchesRecipe() && (craftingResult = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w())) != null) {
            this.pullOneResultStack();
            this.func_70296_d();
            return craftingResult;
        }
        return null;
    }

    private void pullOneResultStack() {
        ItemStack[] aitemstack = CraftingManager.func_77594_a().func_180303_b((InventoryCrafting)this.craftMatrix, this.field_145850_b);
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = this.craftMatrix.func_70301_a(i);
            ItemStack itemstack1 = aitemstack[i];
            if (itemstack != null) {
                this.craftMatrix.func_70298_a(i, 1);
            }
            if (itemstack1 == null || this.craftMatrix.func_70301_a(i) != null) continue;
            this.craftMatrix.func_70299_a(i, itemstack1);
        }
    }

    protected boolean stillMatchesRecipe() {
        int emptyCount = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            ItemStack targetOther = this.memory[i];
            if (targetOther == null && stack == null || targetOther != null && stack != null && stack.field_77994_a > 0 && this.sameItem(targetOther, stack)) continue;
            return false;
        }
        return emptyCount < 9;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= 0) {
            return this.craftMatrix.func_70304_b(par1);
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        ItemStack craftingResult;
        if (par1 >= 0 && par1 < 9) {
            this.craftMatrix.func_70299_a(par1, par2ItemStack);
        } else if ((par1 == 9 && par2ItemStack == null || par2ItemStack.field_77994_a == 0) && this.stillMatchesRecipe() && (craftingResult = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w())) != null) {
            this.pullOneResultStack();
        }
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.magneticcrafting.name");
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (GCCoreUtil.getEffectiveSide() == Side.SERVER) {
            this.craftMatrix.func_174888_l();
            for (int i = 0; i < 9; ++i) {
                this.memory[i] = null;
            }
            NBTTagList contents = nbt.func_150295_c("Items", 10);
            if (contents != null && contents.func_74745_c() > 0) {
                for (int i = 0; i < contents.func_74745_c(); ++i) {
                    NBTTagCompound var4 = contents.func_150305_b(i);
                    int slot = var4.func_74771_c("Slot") & 0xFF;
                    if (slot < 9) {
                        this.craftMatrix.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)var4));
                        continue;
                    }
                    if (slot >= 18) continue;
                    this.memory[slot - 9] = ItemStack.func_77949_a((NBTTagCompound)var4);
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound var4;
        int i;
        super.func_145841_b(nbt);
        NBTTagList var2 = new NBTTagList();
        for (i = 0; i < 9; ++i) {
            if (this.craftMatrix.func_70301_a(i) == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.craftMatrix.func_70301_a(i).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        for (i = 0; i < 9; ++i) {
            if (this.memory[i] == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)(i + 9));
            this.memory[i].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        ItemStack target;
        if (index >= 9) {
            return false;
        }
        boolean override = this.overriddenMemory();
        ItemStack itemStack = target = override ? ItemStack.func_77944_b((ItemStack)this.craftMatrix.func_70301_a(index)) : this.memory[index];
        if (target != null && stack != null && this.sameItem(target, stack)) {
            ItemStack is3 = this.func_70301_a(index);
            if (is3 == null) {
                return true;
            }
            int currentSize = is3.field_77994_a;
            for (int i = 0; i < 9; ++i) {
                ItemStack targetOther;
                if (i == index) continue;
                ItemStack itemStack2 = targetOther = override ? ItemStack.func_77944_b((ItemStack)this.craftMatrix.func_70301_a(i)) : this.memory[i];
                if (targetOther == null || !this.sameItem(targetOther, stack)) continue;
                ItemStack itemstack2 = this.craftMatrix.func_70301_a(i);
                if (itemstack2 == null) {
                    return false;
                }
                if (!this.sameItem(stack, itemstack2) || itemstack2.field_77994_a >= currentSize) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 9 && this.stillMatchesRecipe();
    }

    private boolean sameItem(ItemStack target, ItemStack stack) {
        return target.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == target.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)target);
    }

    public boolean overrideMemory(ItemStack itemstack1, ItemStack[] memory2) {
        boolean allEmpty = true;
        for (int i = 0; i < 9; ++i) {
            if (this.craftMatrix.func_70301_a(i) == null) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return false;
        }
        if (CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w()) != null) {
            int i;
            boolean fuzzyMatch = true;
            for (i = 0; i < 9; ++i) {
                if (this.craftMatrix.func_70301_a(i) == null || this.matchingStacks(this.craftMatrix.func_70301_a(i), this.getMemory(i))) continue;
                fuzzyMatch = false;
                break;
            }
            if (!fuzzyMatch) {
                for (i = 0; i < 9; ++i) {
                    if (!this.matchingStacks(itemstack1, this.craftMatrix.func_70301_a(i))) continue;
                    for (int j = 0; j < 9; ++j) {
                        memory2[j] = ItemStack.func_77944_b((ItemStack)this.craftMatrix.func_70301_a(j));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean overriddenMemory() {
        if (CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.func_145831_w()) != null) {
            for (int i = 0; i < 9; ++i) {
                if (this.craftMatrix.func_70301_a(i) == null || this.matchingStacks(this.craftMatrix.func_70301_a(i), this.getMemory(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchingStacks(ItemStack stack, ItemStack target) {
        return target != null && target.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == target.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)target) && target.func_77985_e() && target.field_77994_a < target.func_77976_d();
    }
}

