/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityCircuitFabricator
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMachineSides {
    public static final int PROCESS_TIME_REQUIRED = 300;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = null;
    private long ticks;
    private ItemStack[] containingItems = new ItemStack[7];
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityCircuitFabricator() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 40.0f : 20.0f);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateInput();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    ++this.processTicks;
                    if (this.processTicks >= this.getProcessTimeRequired()) {
                        this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), "random.anvil_land", 0.2f, 0.5f);
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    public int getProcessTimeRequired() {
        return 600 / (1 + this.poweredByTierGC);
    }

    public void updateInput() {
        this.producingStack = CircuitFabricatorRecipes.getOutputForInput(Arrays.copyOfRange(this.containingItems, 1, 6));
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack == null) {
            return false;
        }
        if (this.containingItems[6] == null) {
            return true;
        }
        if (this.containingItems[6] != null && !this.containingItems[6].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.containingItems[6] == null ? 0 : this.containingItems[6].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void compressItems() {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack.func_77946_l();
            if (this.field_145850_b.field_73011_w instanceof IZeroGDimension && resultItemStack.func_77973_b() == GCItems.basicItem) {
                resultItemStack.field_77994_a = resultItemStack.func_77952_i() == 13 ? 5 : (resultItemStack.func_77952_i() == 12 ? 15 : (resultItemStack.field_77994_a *= 2));
            }
            if (this.containingItems[6] == null) {
                this.containingItems[6] = resultItemStack;
            } else if (this.containingItems[6].func_77969_a(resultItemStack)) {
                if (this.containingItems[6].field_77994_a + resultItemStack.field_77994_a > 64) {
                    resultItemStack.field_77994_a = this.containingItems[6].field_77994_a + resultItemStack.field_77994_a - 64;
                    GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), resultItemStack);
                    this.containingItems[6].field_77994_a = 64;
                } else {
                    this.containingItems[6].field_77994_a += resultItemStack.field_77994_a;
                }
            }
        }
        for (int i = 1; i < 6; ++i) {
            this.func_70298_a(i, 1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        this.addMachineSidesToNBT(par1NBTTagCompound);
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine2.5.name");
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        if (slotID > 5) {
            return false;
        }
        ArrayList<ItemStack> list = CircuitFabricatorRecipes.slotValidItems.get(slotID - 1);
        for (ItemStack test : list) {
            if (!test.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        boolean siliconFlag;
        if (side == EnumFacing.DOWN) {
            return new int[]{6};
        }
        boolean bl = siliconFlag = this.containingItems[2] != null && (this.containingItems[3] == null || this.containingItems[3].field_77994_a < this.containingItems[2].field_77994_a);
        if (siliconFlag) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray = nArray2;
            nArray2[4] = 5;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 4;
            nArray = nArray3;
            nArray3[4] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID < 6 && this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 6;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachine2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachine2.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }
}

