/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.HashSet;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

class AirLockProtocol {
    private ArrayList<BlockPos> adjacentAirLocks = new ArrayList();
    private HashSet<BlockPos> checked = new HashSet();
    private final World worldObj;
    private final TileEntity head;
    private final int maxLoops;
    private int airLocksDimension1Min = 0;
    private int airLocksDimension1Max = 0;
    private int airLocksDimension2Min = 0;
    private int airLocksDimension2Max = 0;
    public int minX = 6000000;
    public int maxX = -6000000;
    public int minY = 6000000;
    public int maxY = -6000000;
    public int minZ = 6000000;
    public int maxZ = -6000000;

    public AirLockProtocol(TileEntity head) {
        this.worldObj = head.func_145831_w();
        this.head = head;
        this.maxLoops = 26;
    }

    private void loopThrough(BlockPos pos, int loops) {
        int xAligned = this.head.func_174877_v().func_177958_n();
        int zAligned = this.head.func_174877_v().func_177952_p();
        for (int x = -1; x <= 1; ++x) {
            int xTest = pos.func_177958_n() + x;
            for (int z = -1; z <= 1; ++z) {
                int zTest = pos.func_177952_p() + z;
                if (xTest != xAligned && zTest != zAligned) continue;
                for (int y = -1; y <= 1; ++y) {
                    BlockPos testPos;
                    if (x == 0 && y == 0 && z == 0 || this.checked.contains(testPos = new BlockPos(xTest, pos.func_177956_o() + y, zTest))) continue;
                    this.checked.add(testPos);
                    if (!(this.worldObj.func_175625_s(testPos) instanceof TileEntityAirLock)) continue;
                    this.adjacentAirLocks.add(testPos);
                    if (loops <= 1) continue;
                    this.loopThrough(testPos, loops - 1);
                }
            }
        }
    }

    private void loopThroughHorizontal(BlockPos pos, int loops) {
        int yTest = pos.func_177956_o();
        for (int x = -1; x <= 1; ++x) {
            int xTest = pos.func_177958_n() + x;
            for (int z = -1; z <= 1; ++z) {
                BlockPos testPos;
                if (x == 0 && z == 0 || this.checked.contains(testPos = new BlockPos(xTest, yTest, pos.func_177952_p() + z))) continue;
                this.checked.add(testPos);
                if (!(this.worldObj.func_175625_s(testPos) instanceof TileEntityAirLock)) continue;
                this.adjacentAirLocks.add(testPos);
                if (loops <= 1) continue;
                this.loopThroughHorizontal(testPos, loops - 1);
            }
        }
    }

    public int calculate(boolean horizontal) {
        if (this.worldObj.field_72995_K) {
            return -1;
        }
        this.minX = 6000000;
        this.maxX = -6000000;
        this.minY = 6000000;
        this.maxY = -6000000;
        this.minZ = 6000000;
        this.maxZ = -6000000;
        this.adjacentAirLocks = new ArrayList();
        this.checked.clear();
        BlockPos headPos = this.head.func_174877_v();
        this.checked.add(headPos);
        this.adjacentAirLocks.add(headPos);
        if (horizontal) {
            this.loopThroughHorizontal(headPos, this.maxLoops);
        } else {
            this.loopThrough(headPos, this.maxLoops);
        }
        for (BlockPos airLock : this.adjacentAirLocks) {
            if (airLock.func_177958_n() < this.minX) {
                this.minX = airLock.func_177958_n();
            }
            if (airLock.func_177958_n() > this.maxX) {
                this.maxX = airLock.func_177958_n();
            }
            if (airLock.func_177956_o() < this.minY) {
                this.minY = airLock.func_177956_o();
            }
            if (airLock.func_177956_o() > this.maxY) {
                this.maxY = airLock.func_177956_o();
            }
            if (airLock.func_177952_p() < this.minZ) {
                this.minZ = airLock.func_177952_p();
            }
            if (airLock.func_177952_p() <= this.maxZ) continue;
            this.maxZ = airLock.func_177952_p();
        }
        int count = this.maxX - this.minX + this.maxZ - this.minZ + this.maxY - this.minY;
        if (count > 24 || this.maxX - this.minX <= 1 && this.maxZ - this.minZ <= 1 || !horizontal && this.maxY - this.minY <= 1) {
            return -1;
        }
        if (horizontal && (this.maxX - this.minX <= 1 || this.maxZ - this.minZ <= 1)) {
            return -1;
        }
        this.airLocksDimension1Min = 0;
        this.airLocksDimension1Max = 0;
        this.airLocksDimension2Min = 0;
        this.airLocksDimension2Max = 0;
        if (horizontal) {
            this.checkDimensionsHorizontal();
        } else {
            this.checkDimensions();
        }
        if (this.airLocksDimension2Max == 0 || this.airLocksDimension2Min == 0 || this.airLocksDimension1Min == 0 || this.airLocksDimension1Max == 0 || this.airLocksDimension2Max != this.airLocksDimension2Min || this.airLocksDimension1Max != this.airLocksDimension1Min) {
            return -1;
        }
        return this.adjacentAirLocks.size();
    }

    private void checkDimensions() {
        block7: {
            int z;
            TileEntity tileAt;
            block6: {
                int x;
                int y;
                for (y = this.minY; y <= this.maxY; ++y) {
                    tileAt = this.worldObj.func_175625_s(new BlockPos(this.minX, y, this.minZ));
                    if (!(tileAt instanceof TileEntityAirLock)) continue;
                    ++this.airLocksDimension1Min;
                }
                for (y = this.minY; y <= this.maxY; ++y) {
                    tileAt = this.worldObj.func_175625_s(new BlockPos(this.maxX, y, this.maxZ));
                    if (!(tileAt instanceof TileEntityAirLock)) continue;
                    ++this.airLocksDimension1Max;
                }
                if (this.minX == this.maxX) break block6;
                for (x = this.minX; x <= this.maxX; ++x) {
                    tileAt = this.worldObj.func_175625_s(new BlockPos(x, this.maxY, this.maxZ));
                    if (!(tileAt instanceof TileEntityAirLock)) continue;
                    ++this.airLocksDimension2Max;
                }
                for (x = this.minX; x <= this.maxX; ++x) {
                    tileAt = this.worldObj.func_175625_s(new BlockPos(x, this.minY, this.maxZ));
                    if (!(tileAt instanceof TileEntityAirLock)) continue;
                    ++this.airLocksDimension2Min;
                }
                break block7;
            }
            if (this.minZ == this.maxZ) break block7;
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(this.maxX, this.maxY, z));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension2Max;
            }
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(this.maxX, this.minY, z));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension2Min;
            }
        }
    }

    private void checkDimensionsHorizontal() {
        TileEntity tileAt;
        if (this.minX != this.maxX) {
            int x;
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(x, this.minY, this.maxZ));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension1Max;
            }
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(x, this.minY, this.minZ));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension1Min;
            }
        }
        if (this.minZ != this.maxZ) {
            int z;
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(this.maxX, this.minY, z));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension2Max;
            }
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_175625_s(new BlockPos(this.minX, this.minY, z));
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksDimension2Min;
            }
        }
    }
}

