/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.command.CommandGCHouston;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldDataSpaceRaces;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.fluid.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.network.GalacticraftPacketHandler;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTransmitter;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPainter;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledDimensionChange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TickHandlerServer {
    private static Map<Integer, CopyOnWriteArrayList<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<ScheduledBlockChange>>();
    private static Map<Integer, CopyOnWriteArrayList<BlockVec3>> scheduledTorchUpdates = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<BlockVec3>>();
    private static Map<Integer, Set<BlockPos>> edgeChecks = new TreeMap<Integer, Set<BlockPos>>();
    private static LinkedList<EnergyNetwork> networkTicks = new LinkedList();
    public static Map<Integer, Map<Long, List<Footprint>>> serverFootprintMap = new TreeMap<Integer, Map<Long, List<Footprint>>>();
    public static List<BlockVec3Dim> footprintBlockChanges = Lists.newArrayList();
    public static WorldDataSpaceRaces spaceRaceData = null;
    public static ArrayList<EntityPlayerMP> playersRequestingMapData = Lists.newArrayList();
    private static long tickCount;
    public static LinkedList<TileEntityFluidTransmitter> oxygenTransmitterUpdates;
    public static LinkedList<TileBaseConductor> energyTransmitterUpdates;
    private static CopyOnWriteArrayList<ScheduledDimensionChange> scheduledDimensionChanges;
    private final int MAX_BLOCKS_PER_TICK = 50000;
    private static List<GalacticraftPacketHandler> packetHandlers;
    private static List<FluidNetwork> fluidNetworks;
    public static int timerHoustonCommand;
    private static Set<Integer> worldsNeedingUpdate;

    public static void addFluidNetwork(FluidNetwork network) {
        fluidNetworks.add(network);
    }

    public static void removeFluidNetwork(FluidNetwork network) {
        fluidNetworks.remove(network);
    }

    public static void addPacketHandler(GalacticraftPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (GalacticraftPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.world);
        }
    }

    public static void restart() {
        scheduledBlockChanges.clear();
        scheduledTorchUpdates.clear();
        edgeChecks.clear();
        networkTicks.clear();
        serverFootprintMap.clear();
        oxygenTransmitterUpdates.clear();
        energyTransmitterUpdates.clear();
        playersRequestingMapData.clear();
        networkTicks.clear();
        for (SpaceRace race : SpaceRaceManager.getSpaceRaces()) {
            SpaceRaceManager.removeSpaceRace(race);
        }
        spaceRaceData = null;
        tickCount = 0L;
        fluidNetworks.clear();
        MapUtil.reset();
    }

    public static void addFootprint(long chunkKey, Footprint print, int dimID) {
        List<Footprint> footprints;
        Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(dimID);
        if (footprintMap == null) {
            footprintMap = new HashMap<Long, List<Footprint>>();
            serverFootprintMap.put(dimID, footprintMap);
            footprints = new ArrayList<Footprint>();
            footprintMap.put(chunkKey, footprints);
        } else {
            footprints = footprintMap.get(chunkKey);
            if (footprints == null) {
                footprints = new ArrayList<Footprint>();
                footprintMap.put(chunkKey, footprints);
            }
        }
        footprints.add(print);
    }

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewDimensionChange(ScheduledDimensionChange change) {
        scheduledDimensionChanges.add(change);
    }

    public static void scheduleNewTorchUpdate(int dimID, List<BlockVec3> torches) {
        CopyOnWriteArrayList<BlockVec3> updateList = scheduledTorchUpdates.get(dimID);
        if (updateList == null) {
            updateList = new CopyOnWriteArrayList();
        }
        updateList.addAll(torches);
        scheduledTorchUpdates.put(dimID, updateList);
    }

    public static void scheduleNewEdgeCheck(int dimID, BlockPos edgeBlock) {
        Set<BlockPos> updateList = edgeChecks.get(dimID);
        if (updateList == null) {
            updateList = new HashSet<BlockPos>();
        }
        updateList.add(edgeBlock);
        edgeChecks.put(dimID, updateList);
    }

    public static boolean scheduledForChange(int dimID, BlockPos test) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList != null) {
            for (ScheduledBlockChange change : changeList) {
                if (!test.equals((Object)change.getChangePosition())) continue;
                return true;
            }
        }
        return false;
    }

    public static void scheduleNetworkTick(EnergyNetwork grid) {
        networkTicks.add(grid);
    }

    public static void removeNetworkTick(EnergyNetwork grid) {
        networkTicks.remove(grid);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Object world;
            Object worlds;
            WorldServer world2;
            if (timerHoustonCommand > 0 && --timerHoustonCommand == 0) {
                CommandGCHouston.reset();
            }
            for (ScheduledDimensionChange change : scheduledDimensionChanges) {
                try {
                    GCPlayerStats stats = GCPlayerStats.get((Entity)change.getPlayer());
                    WorldProvider worldProvider = WorldUtil.getProviderForNameServer(change.getDimensionName());
                    if (worldProvider != null) {
                        Integer dim = GCCoreUtil.getDimensionID(worldProvider);
                        GCLog.info("Found matching world (" + dim.toString() + ") for name: " + change.getDimensionName());
                        if (change.getPlayer().field_70170_p instanceof WorldServer) {
                            WorldServer world3 = (WorldServer)change.getPlayer().field_70170_p;
                            WorldUtil.transferEntityToDimension((Entity)change.getPlayer(), dim, world3);
                        }
                    } else {
                        GCLog.severe("World not found when attempting to transfer entity to dimension: " + change.getDimensionName());
                    }
                    stats.setTeleportCooldown(10);
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_CLOSE_GUI, GCCoreUtil.getDimensionID(change.getPlayer().field_70170_p), new Object[0]), change.getPlayer());
                }
                catch (Exception e) {
                    GCLog.severe("Error occurred when attempting to transfer entity to dimension: " + change.getDimensionName());
                    e.printStackTrace();
                }
            }
            scheduledDimensionChanges.clear();
            if (MapUtil.calculatingMap.get()) {
                MapUtil.BiomeMapNextTick_MultiThreaded();
            } else if (!MapUtil.doneOverworldTexture) {
                MapUtil.makeOverworldTexture();
            }
            if (spaceRaceData == null && (spaceRaceData = (WorldDataSpaceRaces)(world2 = server.func_71218_a(0)).func_175693_T().func_75742_a(WorldDataSpaceRaces.class, "../galacticraft/GCSpaceRaceData")) == null) {
                spaceRaceData = new WorldDataSpaceRaces("../galacticraft/GCSpaceRaceData");
                world2.func_175693_T().func_75745_a("../galacticraft/GCSpaceRaceData", (WorldSavedData)spaceRaceData);
            }
            SpaceRaceManager.tick();
            TileEntityOxygenSealer.onServerTick();
            if (tickCount % 33L == 0L) {
                worlds = server.field_71305_c;
                for (int i = ((WorldServer[])worlds).length - 1; i >= 0; --i) {
                    world = worlds[i];
                    TileEntityPainter.onServerTick((World)world);
                }
            }
            if (tickCount % 100L == 0L) {
                worlds = server.field_71305_c;
                for (int i = 0; i < ((WorldServer[])worlds).length; ++i) {
                    world = worlds[i];
                    ChunkProviderServer chunkProviderServer = world.field_73059_b;
                    Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(GCCoreUtil.getDimensionID((World)world));
                    if (footprintMap == null) continue;
                    boolean mapChanged = false;
                    if (chunkProviderServer != null) {
                        for (Chunk chunk : chunkProviderServer.field_73245_g) {
                            long chunkKey = ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
                            List<Footprint> footprints = footprintMap.get(chunkKey);
                            if (footprints == null) continue;
                            ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                            for (int j = 0; j < footprints.size(); ++j) {
                                footprints.get((int)j).age = (short)(footprints.get((int)j).age + 100);
                                if (footprints.get((int)j).age < 3200) continue;
                                toRemove.add(footprints.get(j));
                            }
                            if (!toRemove.isEmpty()) {
                                footprints.removeAll(toRemove);
                            }
                            footprintMap.put(chunkKey, footprints);
                            mapChanged = true;
                            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_FOOTPRINT_LIST, GCCoreUtil.getDimensionID((World)worlds[i]), new Object[]{chunkKey, footprints.toArray(new Footprint[footprints.size()])}), GCCoreUtil.getDimensionID((World)worlds[i]));
                        }
                    }
                    if (!mapChanged) continue;
                    serverFootprintMap.put(GCCoreUtil.getDimensionID((World)world), footprintMap);
                }
            }
            if (!footprintBlockChanges.isEmpty()) {
                for (BlockVec3Dim targetPoint : footprintBlockChanges) {
                    WorldServer[] worlds2 = server.field_71305_c;
                    for (int i = 0; i < worlds2.length; ++i) {
                        WorldServer world4 = worlds2[i];
                        if (GCCoreUtil.getDimensionID((World)world4) != targetPoint.dim) continue;
                        long chunkKey = ChunkCoordIntPair.func_77272_a((int)(targetPoint.x >> 4), (int)(targetPoint.z >> 4));
                        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_FOOTPRINTS_REMOVED, GCCoreUtil.getDimensionID((World)world4), new Object[]{chunkKey, new BlockVec3(targetPoint.x, targetPoint.y, targetPoint.z)}), new NetworkRegistry.TargetPoint(targetPoint.dim, (double)targetPoint.x, (double)targetPoint.y, (double)targetPoint.z, 50.0));
                    }
                }
                footprintBlockChanges.clear();
            }
            if (tickCount % 20L == 0L && !playersRequestingMapData.isEmpty()) {
                File baseFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "galacticraft/overworldMap");
                if (!baseFolder.exists() && !baseFolder.mkdirs()) {
                    GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
                } else {
                    ArrayList<EntityPlayerMP> copy = new ArrayList<EntityPlayerMP>(playersRequestingMapData);
                    BufferedImage reusable = new BufferedImage(400, 400, 1);
                    for (EntityPlayerMP playerMP : copy) {
                        GCPlayerStats stats = GCPlayerStats.get((Entity)playerMP);
                        MapUtil.makeVanillaMap(playerMP.field_71093_bK, (int)Math.floor(stats.getCoordsTeleportedFromZ()) >> 4, (int)Math.floor(stats.getCoordsTeleportedFromZ()) >> 4, baseFolder, reusable);
                    }
                    playersRequestingMapData.removeAll(copy);
                }
            }
            ++tickCount;
            ++EnergyNetwork.tickCount;
        } else if (event.phase == TickEvent.Phase.END) {
            LinkedList<Object> pass;
            for (FluidNetwork network : new ArrayList<FluidNetwork>(fluidNetworks)) {
                if (!network.pipes.isEmpty()) {
                    network.tickEnd();
                    continue;
                }
                fluidNetworks.remove(network);
            }
            int maxPasses = 10;
            while (!networkTicks.isEmpty()) {
                pass = new LinkedList<Object>();
                pass.addAll(networkTicks);
                networkTicks.clear();
                for (EnergyNetwork energyNetwork : pass) {
                    energyNetwork.tickEnd();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!oxygenTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(oxygenTransmitterUpdates);
                oxygenTransmitterUpdates.clear();
                for (TileEntityFluidTransmitter tileEntityFluidTransmitter : pass) {
                    if (tileEntityFluidTransmitter.func_145837_r()) continue;
                    tileEntityFluidTransmitter.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!energyTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(energyTransmitterUpdates);
                energyTransmitterUpdates.clear();
                for (TileBaseConductor tileBaseConductor : pass) {
                    if (tileBaseConductor.func_145837_r()) continue;
                    tileBaseConductor.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
        }
    }

    public static void markWorldNeedsUpdate(int dimension) {
        worldsNeedingUpdate.add(dimension);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            int dimensionID;
            CopyOnWriteArrayList<BlockVec3> torchList;
            WorldServer world = (WorldServer)event.world;
            CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(GCCoreUtil.getDimensionID((World)world));
            if (changeList != null && !changeList.isEmpty()) {
                int blockCount = 0;
                int blockCountMax = Math.max(this.MAX_BLOCKS_PER_TICK, changeList.size() / 4);
                ArrayList<ScheduledBlockChange> newList = new ArrayList<ScheduledBlockChange>(Math.max(0, changeList.size() - blockCountMax));
                for (ScheduledBlockChange change : changeList) {
                    if (++blockCount > blockCountMax) {
                        newList.add(change);
                        continue;
                    }
                    if (change == null) continue;
                    BlockPos changePosition = change.getChangePosition();
                    Block block = world.func_180495_p(changePosition).func_177230_c();
                    if (changePosition == null || !(block instanceof BlockAir) && block != Blocks.field_150480_ab) continue;
                    world.func_180501_a(changePosition, change.getChangeID().func_176203_a(change.getChangeMeta()), change.getChangeUpdateFlag());
                }
                changeList.clear();
                scheduledBlockChanges.remove(GCCoreUtil.getDimensionID((World)world));
                if (newList.size() > 0) {
                    scheduledBlockChanges.put(GCCoreUtil.getDimensionID((World)world), new CopyOnWriteArrayList(newList));
                }
            }
            if ((torchList = scheduledTorchUpdates.get(GCCoreUtil.getDimensionID((World)world))) != null && !torchList.isEmpty()) {
                for (BlockVec3 torch : torchList) {
                    BlockPos pos;
                    Block b;
                    if (torch == null || !((b = world.func_180495_p(pos = new BlockPos(torch.x, torch.y, torch.z)).func_177230_c()) instanceof BlockUnlitTorch)) continue;
                    world.func_175684_a(pos, b, 2 + world.field_73012_v.nextInt(30));
                }
                torchList.clear();
                scheduledTorchUpdates.remove(GCCoreUtil.getDimensionID((World)world));
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                try {
                    Block entityList;
                    int dim = GCCoreUtil.getDimensionID(WorldUtil.getProviderForNameServer(((IOrbitDimension)world.field_73011_w).getPlanetToOrbit()));
                    int minY = ((IOrbitDimension)world.field_73011_w).getYCoordToTeleportToPlanet();
                    for (Block e : entityList = world.field_72996_f.toArray(new Entity[world.field_72996_f.size()])) {
                        if (!(e.field_70163_u <= (double)minY) || e.field_70170_p != world) continue;
                        WorldUtil.transferEntityToDimension((Entity)e, dim, world, false, null);
                    }
                }
                catch (Exception dim) {
                    // empty catch block
                }
            }
            if (worldsNeedingUpdate.contains(dimensionID = GCCoreUtil.getDimensionID((World)world))) {
                worldsNeedingUpdate.remove(dimensionID);
                for (Object obj : event.world.field_147482_g) {
                    TileEntity tile = (TileEntity)obj;
                    if (!(tile instanceof TileEntityFluidTank)) continue;
                    ((TileEntityFluidTank)tile).updateClient = true;
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            for (GalacticraftPacketHandler handler : packetHandlers) {
                handler.tick((World)world);
            }
            int dimID = GCCoreUtil.getDimensionID((World)world);
            Set<BlockPos> edgesList = edgeChecks.get(dimID);
            HashSet<BlockPos> checkedThisTick = new HashSet<BlockPos>();
            if (edgesList != null && !edgesList.isEmpty()) {
                ArrayList<BlockPos> edgesListCopy = new ArrayList<BlockPos>();
                edgesListCopy.addAll(edgesList);
                for (BlockPos edgeBlock : edgesListCopy) {
                    if (edgeBlock == null || checkedThisTick.contains(edgeBlock) || TickHandlerServer.scheduledForChange(dimID, edgeBlock)) continue;
                    ThreadFindSeal done = new ThreadFindSeal((World)world, edgeBlock, 0, new ArrayList<TileEntityOxygenSealer>());
                    checkedThisTick.addAll(done.checkedAll());
                }
                edgeChecks.remove(GCCoreUtil.getDimensionID((World)world));
            }
        }
    }

    static {
        oxygenTransmitterUpdates = new LinkedList();
        energyTransmitterUpdates = new LinkedList();
        scheduledDimensionChanges = new CopyOnWriteArrayList();
        packetHandlers = Lists.newCopyOnWriteArrayList();
        fluidNetworks = Lists.newArrayList();
        worldsNeedingUpdate = new HashSet<Integer>();
    }
}

