/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDynamic
extends PacketBase {
    private int type;
    private Object[] data;
    private ArrayList<Object> sendData;
    private ByteBuf payloadData;

    public PacketDynamic() {
    }

    public PacketDynamic(Entity entity) {
        super(GCCoreUtil.getDimensionID(entity.field_70170_p));
        assert (entity instanceof IPacketReceiver) : "Entity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 0;
        this.data = new Object[]{entity.func_145782_y()};
        this.sendData = new ArrayList();
        ((IPacketReceiver)entity).getNetworkedData(this.sendData);
    }

    public PacketDynamic(TileEntity tile) {
        super(GCCoreUtil.getDimensionID(tile.func_145831_w()));
        assert (tile instanceof IPacketReceiver) : "TileEntity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 1;
        this.data = new Object[]{tile.func_174877_v()};
        this.sendData = new ArrayList();
        ((IPacketReceiver)tile).getNetworkedData(this.sendData);
    }

    public boolean isEmpty() {
        return this.sendData.isEmpty();
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type);
        switch (this.type) {
            case 0: {
                buffer.writeInt(((Integer)this.data[0]).intValue());
                break;
            }
            case 1: {
                buffer.writeInt(((BlockPos)this.data[0]).func_177958_n());
                buffer.writeInt(((BlockPos)this.data[0]).func_177956_o());
                buffer.writeInt(((BlockPos)this.data[0]).func_177952_p());
            }
        }
        ByteBuf payloadData = Unpooled.buffer();
        try {
            NetworkUtil.encodeData(payloadData, this.sendData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int readableBytes = payloadData.readableBytes();
        buffer.writeInt(readableBytes);
        buffer.writeBytes(payloadData);
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = buffer.readInt();
        World world = GalacticraftCore.proxy.getWorldForID(this.getDimensionID());
        if (world == null) {
            FMLLog.severe((String)("Failed to get world for dimension ID: " + this.getDimensionID()), (Object[])new Object[0]);
        }
        switch (this.type) {
            case 0: {
                this.data = new Object[1];
                this.data[0] = buffer.readInt();
                int length = buffer.readInt();
                this.payloadData = Unpooled.copiedBuffer((ByteBuf)buffer.readBytes(length));
                break;
            }
            case 1: {
                this.data = new Object[1];
                this.data[0] = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
                int length = buffer.readInt();
                this.payloadData = Unpooled.copiedBuffer((ByteBuf)buffer.readBytes(length));
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handleData(Side.CLIENT, player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handleData(Side.SERVER, player);
    }

    private void handleData(Side side, EntityPlayer player) {
        switch (this.type) {
            case 0: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data[0]).intValue());
                if (!(entity instanceof IPacketReceiver)) break;
                if (this.payloadData.readableBytes() > 0) {
                    ((IPacketReceiver)entity).decodePacketdata(this.payloadData);
                }
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP) || entity == null) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(entity), (EntityPlayerMP)player);
                break;
            }
            case 1: {
                TileEntity tile;
                if (!player.field_70170_p.func_175668_a((BlockPos)this.data[0], false) || !((tile = player.field_70170_p.func_175625_s((BlockPos)this.data[0])) instanceof IPacketReceiver)) break;
                if (this.payloadData.readableBytes() > 0) {
                    ((IPacketReceiver)tile).decodePacketdata(this.payloadData);
                }
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP) || tile == null) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(tile), (EntityPlayerMP)player);
            }
        }
    }
}

