/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import java.util.List;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemCanisterGeneric
extends ItemFluidContainer {
    private String allowedFluid = null;
    public static final int EMPTY = 1001;
    private static boolean isTELoaded = CompatibilityManager.isTELoaded();

    public ItemCanisterGeneric(String assetName) {
        super(0, 1000);
        this.func_77656_e(1001);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(assetName);
        this.func_77642_a(GCItems.oilCanister);
        this.func_77627_a(true);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack(par1, 1, 1));
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (isTELoaded && JavaUtil.instance.isCalledBy("thermalexpansion.block.machine.TileTransposer")) {
            return null;
        }
        return new ItemStack(this.func_77668_q(), 1, 1001);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (1001 == par1ItemStack.func_77952_i()) {
            if (par1ItemStack.func_77973_b() != GCItems.oilCanister) {
                this.replaceEmptyCanisterItem(par1ItemStack, GCItems.oilCanister);
            }
            par1ItemStack.func_77982_d(null);
        } else if (par1ItemStack.func_77952_i() <= 0) {
            par1ItemStack.func_77964_b(1);
        }
    }

    public void setAllowedFluid(String name) {
        this.allowedFluid = name;
    }

    public String getAllowedFluid() {
        return this.allowedFluid;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || resource.amount == 0 || container == null || container.func_77952_i() <= 1 || !(container.func_77973_b() instanceof ItemCanisterGeneric)) {
            return 0;
        }
        String fluidName = resource.getFluid().getName();
        if (container.func_77952_i() >= 1001) {
            for (ItemCanisterGeneric i : GCItems.canisterTypes) {
                if (!fluidName.equalsIgnoreCase(i.allowedFluid)) continue;
                if (!doFill) {
                    return Math.min(resource.amount, this.capacity);
                }
                this.replaceEmptyCanisterItem(container, (Item)i);
                break;
            }
            container.func_77982_d(null);
            container.func_77964_b(1001);
        } else {
            container.func_77982_d(null);
            super.fill(container, this.getFluid(container), true);
        }
        if (fluidName.equalsIgnoreCase(((ItemCanisterGeneric)container.func_77973_b()).allowedFluid)) {
            int added = super.fill(container, resource, doFill);
            if (doFill && added > 0) {
                container.func_77964_b(Math.max(1, container.func_77952_i() - added));
            }
            return added;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.allowedFluid == null || container.func_77952_i() >= 1001) {
            return null;
        }
        container.func_77982_d(null);
        super.fill(container, this.getFluid(container), true);
        FluidStack used = super.drain(container, maxDrain, doDrain);
        if (doDrain && used != null && used.amount > 0) {
            this.setNewDamage(container, container.func_77952_i() + used.amount);
        }
        return used;
    }

    protected void setNewDamage(ItemStack container, int newDamage) {
        if ((newDamage = Math.min(newDamage, 1001)) == 1001) {
            container.func_77982_d(null);
            if (container.func_77973_b() != GCItems.oilCanister) {
                this.replaceEmptyCanisterItem(container, GCItems.oilCanister);
                return;
            }
        }
        container.func_77964_b(newDamage);
    }

    private void replaceEmptyCanisterItem(ItemStack container, Item newItem) {
        int stackSize = container.field_77994_a;
        NBTTagCompound tag = new NBTTagCompound();
        container.func_77955_b(tag);
        ResourceLocation resourceloc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)newItem);
        if (resourceloc != null) {
            tag.func_74778_a("id", resourceloc.toString());
        }
        tag.func_74777_a("Damage", (short)1001);
        container.func_77963_c(tag);
    }

    public FluidStack getFluid(ItemStack container) {
        String fluidName = ((ItemCanisterGeneric)container.func_77973_b()).allowedFluid;
        if (fluidName == null || 1001 == container.func_77952_i()) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, 1001 - container.func_77952_i());
    }
}

