/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.core.fluid.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OxygenPressureProtocol {
    public static final Map<Block, ArrayList<Integer>> nonPermeableBlocks = new HashMap<Block, ArrayList<Integer>>();

    public static void updateSealerStatus(TileEntityOxygenSealer head) {
        try {
            head.threadSeal = new ThreadFindSeal(head);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void onEdgeBlockUpdated(World world, BlockPos vec) {
        if (ConfigManagerCore.enableSealerEdgeChecks) {
            TickHandlerServer.scheduleNewEdgeCheck(GCCoreUtil.getDimensionID(world), vec);
        }
    }

    public static boolean canBlockPassAir(World world, Block block, BlockPos pos, EnumFacing side) {
        IBlockState state;
        if (block == null) {
            return true;
        }
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, pos, side);
        }
        if (block instanceof BlockLeavesBase) {
            return true;
        }
        if (block.func_149662_c()) {
            return block instanceof BlockGravel || block.func_149688_o() == Material.field_151580_n || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return false;
        }
        if (nonPermeableBlocks.containsKey(block)) {
            ArrayList<Integer> metaList = nonPermeableBlocks.get(block);
            state = world.func_180495_p(pos);
            if (metaList.contains(-1) || metaList.contains(state.func_177230_c().func_176201_c(state))) {
                return false;
            }
        }
        if (block instanceof BlockSlab) {
            IBlockState state2 = world.func_180495_p(pos);
            int meta = state2.func_177230_c().func_176201_c(state2);
            return !(side == EnumFacing.DOWN && (meta & 8) == 8 || side == EnumFacing.UP && (meta & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != EnumFacing.UP;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            state = world.func_180495_p(pos);
            if (((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPistonBase.field_176321_a);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid((IBlockAccess)world, pos, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)));
    }

    static {
        for (String s : ConfigManagerCore.sealableIDs) {
            try {
                ArrayList<Object> list;
                BlockTuple bt = ConfigManagerCore.stringToBlock(s, "External Sealable IDs", true);
                if (bt == null) continue;
                int meta = bt.meta;
                if (nonPermeableBlocks.containsKey(bt.block)) {
                    list = nonPermeableBlocks.get(bt.block);
                    if (!list.contains(meta)) {
                        list.add(meta);
                        continue;
                    }
                    GCLog.info("[config] External Sealable IDs: skipping duplicate entry '" + s + "'.");
                    continue;
                }
                list = new ArrayList<Integer>();
                list.add(meta);
                nonPermeableBlocks.put(bt.block, list);
            }
            catch (Exception e) {
                GCLog.severe("[config] External Sealable IDs: error parsing '" + s + "'. Must be in the form Blockname or BlockName:metadata");
            }
        }
    }
}

