/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.fluid;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IBufferTransmitter;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketFluidNetworkUpdate;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class FluidNetwork
implements IGridNetwork<FluidNetwork, IBufferTransmitter<FluidStack>, TileEntity> {
    public Map<BlockPos, IFluidHandler> acceptors = Maps.newHashMap();
    public Map<BlockPos, EnumSet<EnumFacing>> acceptorDirections = Maps.newHashMap();
    public final Set<IBufferTransmitter<FluidStack>> pipes = Sets.newHashSet();
    private Set<IBufferTransmitter<FluidStack>> pipesAdded = Sets.newHashSet();
    private Set<DelayQueue> updateQueue = Sets.newLinkedHashSet();
    public FluidStack buffer;
    private int capacity;
    private World worldObj;
    private int prevBufferAmount;
    private boolean needsUpdate;
    public float fluidScale;
    public Fluid refFluid;
    public boolean didTransfer;
    public boolean prevTransfer;
    public int transferDelay = 0;
    private int prevTransferAmount;
    private int updateDelay;
    private boolean firstUpdate = true;

    public FluidNetwork() {
    }

    public FluidNetwork(Collection<FluidNetwork> toMerge) {
        for (FluidNetwork network : toMerge) {
            if (network == null) continue;
            if (network.buffer != null) {
                if (this.buffer == null) {
                    this.buffer = network.buffer.copy();
                } else if (this.buffer.getFluid() == network.buffer.getFluid()) {
                    this.buffer.amount += network.buffer.amount;
                } else if (network.buffer.amount > this.buffer.amount) {
                    this.buffer = network.buffer.copy();
                }
                network.buffer = null;
            }
            this.adoptNetwork(network);
            network.unregister();
        }
        this.register();
    }

    public void adoptNetwork(FluidNetwork network) {
        for (IBufferTransmitter<FluidStack> iBufferTransmitter : network.pipes) {
            iBufferTransmitter.setNetwork(this);
            this.pipes.add(iBufferTransmitter);
            this.pipesAdded.add(iBufferTransmitter);
            this.updateDelay = this.firstUpdate ? 3 : 1;
        }
        this.acceptors.putAll(network.acceptors);
        for (Map.Entry entry : network.acceptorDirections.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            if (this.acceptorDirections.containsKey(pos)) {
                this.acceptorDirections.get(pos).addAll((Collection)entry.getValue());
                continue;
            }
            this.acceptorDirections.put(pos, (EnumSet<EnumFacing>)entry.getValue());
        }
    }

    public void register() {
        GalacticraftCore.proxy.registerNetwork(this);
    }

    public void unregister() {
        GalacticraftCore.proxy.unregisterNetwork(this);
    }

    public void addTransmitter(IBufferTransmitter<FluidStack> transmitter) {
        this.pipes.add(transmitter);
        this.pipesAdded.add(transmitter);
        this.refresh();
        this.updateDelay = this.firstUpdate ? 20 : 1;
    }

    public void removeTransmitter(IBufferTransmitter<FluidStack> transmitter) {
        this.pipes.remove(transmitter);
        this.updateCapacity();
    }

    public void onTransmitterAdded(IBufferTransmitter<FluidStack> transmitter) {
        FluidStack stack = transmitter.getBuffer();
        if (stack == null || stack.getFluid() == null || stack.amount == 0) {
            return;
        }
        if (this.buffer == null || this.buffer.getFluid() == null || this.buffer.amount == 0) {
            this.buffer = stack.copy();
            stack.amount = 0;
            return;
        }
        if (this.buffer.isFluidEqual(stack)) {
            this.buffer.amount += stack.amount;
        }
        stack.amount = 0;
    }

    public void clamp() {
        if (this.buffer != null && this.buffer.amount > this.getCapacity()) {
            this.buffer.amount = this.capacity;
        }
    }

    public void updateCapacity() {
        this.capacity = 0;
        for (IBufferTransmitter<FluidStack> transmitter : this.pipes) {
            this.capacity += transmitter.getCapacity();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getRequest() {
        return this.getCapacity() - (this.buffer != null ? this.buffer.amount : 0);
    }

    private int emitToAcceptors(FluidStack toSend, boolean doTransfer) {
        ArrayList<Pair<BlockPos, IFluidHandler>> available = new ArrayList<Pair<BlockPos, IFluidHandler>>();
        available.addAll(this.getAcceptors(toSend));
        Collections.shuffle(available);
        int totalSend = 0;
        if (!available.isEmpty()) {
            int divider = available.size();
            int remainder = toSend.amount % divider;
            int each = (toSend.amount - remainder) / divider;
            block0: for (Pair pair : available) {
                int currentSend = each;
                IFluidHandler acceptor = (IFluidHandler)pair.getRight();
                EnumSet<EnumFacing> sides = this.acceptorDirections.get(pair.getLeft());
                if (remainder > 0) {
                    ++currentSend;
                    --remainder;
                }
                for (EnumFacing side : sides) {
                    int prev = totalSend;
                    if (acceptor != null) {
                        FluidStack copy = toSend.copy();
                        copy.amount = currentSend;
                        totalSend += acceptor.fill(side, copy, doTransfer);
                    }
                    if (totalSend <= prev) continue;
                    continue block0;
                }
            }
        }
        if (doTransfer && totalSend > 0 && GCCoreUtil.getEffectiveSide().isServer()) {
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return totalSend;
    }

    public int emitToBuffer(FluidStack toSend, boolean doTransfer) {
        if (toSend == null || this.buffer != null && this.buffer.getFluid() != toSend.getFluid()) {
            return 0;
        }
        int toUse = Math.min(this.getRequest(), toSend.amount);
        if (doTransfer) {
            if (this.buffer == null) {
                this.buffer = toSend.copy();
                this.buffer.amount = toUse;
            } else {
                this.buffer.amount += toUse;
            }
        }
        return toUse;
    }

    public void tickEnd() {
        this.onUpdate();
    }

    public void addUpdate(EntityPlayerMP player) {
        this.updateQueue.add(new DelayQueue(player));
    }

    private IPacket getAddTransmitterUpdate() {
        BlockPos pos = ((TileEntity)this.pipes.iterator().next()).func_174877_v();
        return PacketFluidNetworkUpdate.getAddTransmitterUpdate(GCCoreUtil.getDimensionID(this.worldObj), pos, this.firstUpdate, this.pipesAdded);
    }

    public void onUpdate() {
        if (GCCoreUtil.getEffectiveSide().isServer()) {
            int stored;
            Iterator<DelayQueue> iterator = this.updateQueue.iterator();
            try {
                while (iterator.hasNext()) {
                    DelayQueue queue = iterator.next();
                    if (queue.delay > 0) {
                        --queue.delay;
                        continue;
                    }
                    this.pipesAdded.addAll(this.pipes);
                    GalacticraftCore.packetPipeline.sendTo(this.getAddTransmitterUpdate(), queue.player);
                    this.pipesAdded.clear();
                    iterator.remove();
                }
            }
            catch (Exception queue) {
                // empty catch block
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    BlockPos pos = ((TileEntity)this.pipes.iterator().next()).func_174877_v();
                    GalacticraftCore.packetPipeline.sendToAllAround(this.getAddTransmitterUpdate(), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.worldObj), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
                    this.firstUpdate = false;
                    this.pipesAdded.clear();
                    this.needsUpdate = true;
                }
            }
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.buffer != null ? this.buffer.amount : 0;
            if (stored != this.prevBufferAmount) {
                this.needsUpdate = true;
            }
            this.prevBufferAmount = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                BlockPos pos = ((TileEntity)this.pipes.iterator().next()).func_174877_v();
                GalacticraftCore.packetPipeline.sendToAllAround(PacketFluidNetworkUpdate.getFluidUpdate(GCCoreUtil.getDimensionID(this.worldObj), pos, this.buffer, this.didTransfer), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.worldObj), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 20.0));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.buffer != null) {
                this.prevTransferAmount = this.emitToAcceptors(this.buffer, true);
                if (this.buffer != null) {
                    this.buffer.amount -= this.prevTransferAmount;
                    if (this.buffer.amount <= 0) {
                        this.buffer = null;
                    }
                }
            }
        }
    }

    public void clientTick() {
        this.fluidScale = Math.max(this.fluidScale, this.getScale());
        if (this.didTransfer && this.fluidScale < 1.0f) {
            this.fluidScale = Math.max(this.getScale(), Math.min(1.0f, this.fluidScale + 0.02f));
        } else if (!this.didTransfer && this.fluidScale > 0.0f) {
            this.fluidScale = this.getScale();
            if (this.fluidScale == 0.0f) {
                this.buffer = null;
            }
        }
    }

    public float getScale() {
        if (this.buffer == null || this.getCapacity() == 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.buffer.amount / (float)this.getCapacity());
    }

    public List<Pair<BlockPos, IFluidHandler>> getAcceptors(FluidStack toSend) {
        LinkedList<Pair<BlockPos, IFluidHandler>> toReturn = new LinkedList<Pair<BlockPos, IFluidHandler>>();
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            return toReturn;
        }
        if (this.acceptors == null || this.acceptors.isEmpty()) {
            this.refreshAcceptors();
        }
        ArrayList<BlockPos> acceptorsCopy = new ArrayList<BlockPos>();
        acceptorsCopy.addAll(this.acceptors.keySet());
        block0: for (BlockPos coords : acceptorsCopy) {
            TileEntity tile;
            EnumSet<EnumFacing> sides = this.acceptorDirections.get(coords);
            if (sides == null || sides.isEmpty() || !((tile = this.worldObj.func_175625_s(coords)) instanceof IFluidHandler)) continue;
            IFluidHandler acceptor = (IFluidHandler)tile;
            Fluid fluidToSend = toSend.getFluid();
            for (EnumFacing side : sides) {
                if (!acceptor.canFill(side, fluidToSend)) continue;
                toReturn.add((Pair<BlockPos, IFluidHandler>)Pair.of((Object)coords, (Object)acceptor));
                continue block0;
            }
        }
        return toReturn;
    }

    @Override
    public void refresh() {
        if (this.acceptors != null) {
            this.acceptors.clear();
        }
        try {
            Iterator<IBufferTransmitter<FluidStack>> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                TileEntity tileTransmitter = (TileEntity)transmitter;
                if (transmitter == null) {
                    it.remove();
                    continue;
                }
                transmitter.onNetworkChanged();
                if (tileTransmitter.func_145837_r() || tileTransmitter.func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                if (this.worldObj == null) {
                    this.worldObj = tileTransmitter.func_145831_w();
                }
                transmitter.setNetwork(this);
            }
            this.updateCapacity();
            this.clamp();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh liquid pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void refreshAcceptors() {
        if (this.acceptors == null) {
            this.acceptors = Maps.newHashMap();
        } else {
            this.acceptors.clear();
        }
        try {
            Iterator<IBufferTransmitter<FluidStack>> it = this.pipes.iterator();
            while (it.hasNext()) {
                IBufferTransmitter<FluidStack> transmitter = it.next();
                TileEntity tile = (TileEntity)transmitter;
                if (transmitter == null || tile.func_145837_r() || tile.func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                if (!transmitter.canTransmit()) continue;
                int i = 0;
                for (TileEntity acceptor : transmitter.getAdjacentConnections()) {
                    if (!(acceptor instanceof IBufferTransmitter) && acceptor instanceof IFluidHandler) {
                        EnumFacing facing = EnumFacing.func_82600_a((int)i).func_176734_d();
                        BlockPos acceptorPos = tile.func_174877_v().func_177972_a(facing.func_176734_d());
                        EnumSet<EnumFacing> facingSet = this.acceptorDirections.get(acceptorPos);
                        if (facingSet != null) {
                            facingSet.add(facing);
                        } else {
                            facingSet = EnumSet.of(facing);
                        }
                        this.acceptors.put(acceptorPos, (IFluidHandler)acceptor);
                        this.acceptorDirections.put(acceptorPos, facingSet);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh liquid acceptors", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public ImmutableSet<IBufferTransmitter<FluidStack>> getTransmitters() {
        return ImmutableSet.copyOf(this.pipes);
    }

    @Override
    public FluidNetwork merge(FluidNetwork network) {
        if (network != null && network != this) {
            FluidNetwork newNetwork = new FluidNetwork(Lists.newArrayList((Object[])new FluidNetwork[]{this, network}));
            newNetwork.refresh();
            return newNetwork;
        }
        return this;
    }

    @Override
    public void split(IBufferTransmitter<FluidStack> splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.pipes.remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).func_145831_w(), (INetworkConnection)connectedBlockB, NetworkType.FLUID, splitPoint);
                    finder.init(new BlockVec3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (BlockVec3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    FluidNetwork newNetwork = new FluidNetwork();
                    for (BlockVec3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                        if (!(nodeTile instanceof IBufferTransmitter) || nodeTile == splitPoint) continue;
                        newNetwork.pipes.add((IBufferTransmitter)nodeTile);
                        newNetwork.pipesAdded.add((IBufferTransmitter)nodeTile);
                        newNetwork.onTransmitterAdded((IBufferTransmitter)nodeTile);
                        this.pipes.remove(nodeTile);
                    }
                    newNetwork.refresh();
                    newNetwork.register();
                }
            }
            if (this.pipes.isEmpty()) {
                this.unregister();
            } else {
                this.updateCapacity();
            }
        }
    }

    public String toString() {
        return "FluidNetwork[" + this.hashCode() + "|Pipes:" + this.pipes.size() + "|Acceptors:" + (this.acceptors == null ? 0 : this.acceptors.size()) + "]";
    }

    public static class DelayQueue {
        public EntityPlayerMP player;
        public int delay;

        public DelayQueue(EntityPlayerMP player) {
            this.player = player;
            this.delay = 5;
        }

        public int hashCode() {
            return this.player.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof DelayQueue && ((DelayQueue)obj).player.equals((Object)this.player);
        }
    }
}

