/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import api.player.client.ClientPlayerAPI;
import api.player.client.ClientPlayerBase;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.client.EventHandlerClient;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GCPlayerBaseSP
extends ClientPlayerBase {
    boolean lastIsFlying;
    int lastLandingTicks;

    public GCPlayerBaseSP(ClientPlayerAPI playerAPI) {
        super(playerAPI);
    }

    private IPlayerClient getClientHandler() {
        return ClientProxyCore.playerClientHandler;
    }

    public boolean isEntityInsideOpaqueBlock() {
        return this.getClientHandler().isEntityInsideOpaqueBlock(this.player, super.isEntityInsideOpaqueBlock());
    }

    public void onLivingUpdate() {
        this.getClientHandler().onLivingUpdatePre(this.player);
        super.onLivingUpdate();
        this.getClientHandler().onLivingUpdatePost(this.player);
    }

    public void beforeUpdateEntityActionState() {
        GCPlayerStatsClient stats;
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension && (stats = GCPlayerStatsClient.get((Entity)this.player)).getLandingTicks() > 0) {
            this.player.field_71158_b.field_78902_a *= 0.5f;
            this.player.field_71158_b.field_78900_b *= 0.5f;
        }
    }

    public void afterUpdateEntityActionState() {
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            this.player.func_70637_d(false);
            AxisAlignedBB aABB = this.player.func_174813_aQ();
            if (aABB.field_72338_b % 1.0 == 0.5) {
                this.player.func_174826_a(aABB.func_72317_d(0.0, 1.0E-5, 0.0));
            }
        }
    }

    public void moveEntity(double par1, double par3, double par5) {
        super.moveEntity(par1, par3, par5);
        this.getClientHandler().moveEntity(this.player, par1, par3, par5);
    }

    public void afterMoveEntityWithHeading(float paramFloat1, float paramFloat2) {
        super.afterMoveEntityWithHeading(paramFloat1, paramFloat2);
        if (CompatibilityManager.isSmartMovingLoaded && !this.player.field_71075_bZ.field_75100_b) {
            this.player.field_70181_x += 0.08;
            this.player.field_70181_x -= TransformerHooks.getGravityForEntity((Entity)this.player);
        }
    }

    public void onUpdate() {
        this.getClientHandler().onUpdate(this.player);
        super.onUpdate();
    }

    public boolean isSneaking() {
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)this.player);
            if (stats.getLandingTicks() > 0) {
                if (this.lastLandingTicks == 0) {
                    this.lastLandingTicks = stats.getLandingTicks();
                }
                return stats.getLandingTicks() < this.lastLandingTicks;
            }
            this.lastLandingTicks = 0;
            if (stats.getFreefallHandler().pjumpticks > 0) {
                return true;
            }
            if (EventHandlerClient.sneakRenderOverride) {
                if (stats.getFreefallHandler().testFreefall((EntityPlayer)this.player)) {
                    return false;
                }
                if (stats.isInFreefall()) {
                    return false;
                }
            }
        }
        return super.isSneaking();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float partialTicks) {
        BlockPos blockpos;
        double height = this.player.field_70163_u + (double)this.player.func_70047_e();
        if (height > 255.0) {
            height = 255.0;
        }
        return this.player.field_70170_p.func_175667_e(blockpos = new BlockPos(this.player.field_70165_t, height, this.player.field_70161_v)) ? this.player.field_70170_p.func_175626_b(blockpos, 0) : 0;
    }
}

