/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import java.lang.ref.WeakReference;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProviderStats
implements ICapabilitySerializable<NBTTagCompound> {
    private EntityPlayerMP owner;
    private GCPlayerStats statsCapability;

    public CapabilityProviderStats(EntityPlayerMP owner) {
        this.owner = owner;
        this.statsCapability = (GCPlayerStats)GCCapabilities.GC_STATS_CAPABILITY.getDefaultInstance();
        this.statsCapability.setPlayer(new WeakReference<EntityPlayerMP>(this.owner));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == GCCapabilities.GC_STATS_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (GCCapabilities.GC_STATS_CAPABILITY != null && capability == GCCapabilities.GC_STATS_CAPABILITY) {
            return (T)this.statsCapability;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.statsCapability.saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.statsCapability.loadNBTData(nbt);
    }
}

