/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.ITumblable;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityEvolvedZombie
extends EntityZombie
implements IEntityBreathable,
ITumblable {
    private int conversionTime = 0;
    private float tumbling = 0.0f;
    private float tumbleAngle = 0.0f;

    public EntityEvolvedZombie(World par1World) {
        super(par1World);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        double difficulty = 0.0;
        switch (this.field_70170_p.func_175659_aa()) {
            case HARD: {
                difficulty = 2.0;
                break;
            }
            case NORMAL: {
                difficulty = 1.0;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26 + 0.04 * difficulty);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0 + difficulty);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0 + difficulty * 2.0);
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityIronGolem.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    @Override
    public boolean canBreath() {
        return true;
    }

    public IAttribute getReinforcementsAttribute() {
        return EntityZombie.field_110186_bp;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.48 / (double)WorldUtil.getGravityFactor((Entity)this);
        if (this.field_70181_x < 0.24) {
            this.field_70181_x = 0.24;
        }
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z / 57.295776f;
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_82164_bB() {
        switch (this.field_70146_Z.nextInt(16)) {
            case 0: 
            case 1: 
            case 2: {
                this.func_70099_a(new ItemStack(GCItems.foodItem, 1, 1), 0.0f);
                break;
            }
            case 3: 
            case 4: {
                this.func_145779_a(GCItems.meteoricIronRaw, 1);
                break;
            }
            case 5: 
            case 6: {
                this.func_70099_a(new ItemStack(GCItems.foodItem, 1, 3), 0.0f);
                break;
            }
            case 7: 
            case 8: {
                this.func_70099_a(new ItemStack(GCItems.oxTankMedium, 1, 901 + this.field_70146_Z.nextInt(900)), 0.0f);
                break;
            }
            case 9: {
                this.func_145779_a(GCItems.oxMask, 1);
                break;
            }
            case 10: {
                this.func_145779_a(GCItems.oxygenVent, 1);
                break;
            }
            case 11: 
            case 12: {
                this.func_145779_a(Items.field_151172_bF, 1);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                if (!ConfigManagerCore.challengeMobDropsAndSpawning) break;
                this.func_145779_a(Items.field_151081_bc, 1);
            }
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        Item item = this.func_146068_u();
        int j = this.field_70146_Z.nextInt(2);
        if (item != null) {
            if (p_70628_2_ > 0) {
                j += this.field_70146_Z.nextInt(p_70628_2_ + 1);
            }
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(item, 1);
            }
        }
        if (p_70628_1_ && ConfigManagerCore.challengeMobDropsAndSpawning && j > 0 && this.field_70146_Z.nextInt(6) == 0) {
            this.func_70099_a(new ItemStack(GCItems.basicItem, 1, 3), 0.0f);
        }
    }

    @Override
    public void setTumbling(float value) {
        if (value != 0.0f) {
            if (this.tumbling == 0.0f) {
                this.tumbling = (this.field_70170_p.field_73012_v.nextFloat() + 0.5f) * value;
            }
        } else {
            this.tumbling = 0.0f;
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70128_L) {
            if (this.tumbling != 0.0f && this.field_70122_E) {
                this.tumbling = 0.0f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setSpinPitch(this.tumbling);
            } else {
                this.tumbling = this.getSpinPitch();
                this.tumbleAngle -= this.tumbling;
                if (this.tumbling == 0.0f && this.tumbleAngle != 0.0f) {
                    this.tumbleAngle *= 0.8f;
                    if (Math.abs(this.tumbleAngle) < 1.0f) {
                        this.tumbleAngle = 0.0f;
                    }
                }
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(0.0f));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.tumbling = nbt.func_74760_g("tumbling");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("tumbling", this.tumbling);
    }

    public float getSpinPitch() {
        return this.field_70180_af.func_111145_d(16);
    }

    public void setSpinPitch(float pitch) {
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(pitch));
    }

    @Override
    public float getTumbleAngle(float partial) {
        float angle = this.tumbleAngle - partial * this.tumbling;
        if (angle > 360.0f) {
            this.tumbleAngle -= 360.0f;
            angle -= 360.0f;
        }
        if (angle < 0.0f) {
            this.tumbleAngle += 360.0f;
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public float getTumbleAxisX() {
        double velocity2 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
        if (velocity2 == 0.0) {
            return 1.0f;
        }
        return (float)(this.field_70179_y / (double)MathHelper.func_76133_a((double)velocity2));
    }

    @Override
    public float getTumbleAxisZ() {
        double velocity2 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
        if (velocity2 == 0.0) {
            return 0.0f;
        }
        return (float)(this.field_70159_w / (double)MathHelper.func_76133_a((double)velocity2));
    }
}

