/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileBaseElectricBlock
extends TileBaseUniversalElectrical
implements IDisableableMachine,
IConnector {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean hasEnoughEnergyToRun = false;
    public boolean noRedstoneControl = false;

    public boolean shouldPullEnergy() {
        return this.shouldUseEnergy() || this.getEnergyStoredGC(null) < this.getMaxEnergyStoredGC();
    }

    public abstract boolean shouldUseEnergy();

    public abstract EnumFacing getElectricInputDirection();

    public abstract ItemStack getBatteryInSlot();

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC(null) * (float)i / this.getMaxEnergyStoredGC(null));
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldPullEnergy() && this.getEnergyStoredGC(null) < this.getMaxEnergyStoredGC(null) && this.getBatteryInSlot() != null && this.getElectricInputDirection() != null) {
                this.discharge(this.getBatteryInSlot());
            }
            if (this.getEnergyStoredGC(null) > this.storage.getMaxExtract() && (this.noRedstoneControl || !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v()))) {
                this.hasEnoughEnergyToRun = true;
                if (this.shouldUseEnergy()) {
                    this.storage.extractEnergyGC(this.storage.getMaxExtract(), false);
                } else {
                    this.slowDischarge();
                }
            } else {
                this.hasEnoughEnergyToRun = false;
                this.slowDischarge();
            }
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.disableCooldown > 0) {
            --this.disableCooldown;
        }
    }

    public void slowDischarge() {
        if (this.ticks % 10 == 0) {
            this.storage.extractEnergyGC(5.0f, false);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isDisabled", this.getDisabled(0));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setDisabled(0, nbt.func_74767_n("isDisabled"));
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 10;
        }
    }

    public abstract EnumFacing getFront();

    @Override
    public boolean getDisabled(int index) {
        return this.disabled;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public EnumFacing getFacing(World world, BlockPos pos) {
        return this.getFront();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        ArrayList drops = Lists.newArrayList();
        drops.add(this.func_145838_q().getPickBlock(null, this.field_145850_b, this.func_174877_v(), player));
        return drops;
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        if (this.getElectricInputDirection() == null) {
            return EnumSet.noneOf(EnumFacing.class);
        }
        return EnumSet.of(this.getElectricInputDirection());
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityplayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricInputDirection();
    }

    public String getGUIstatus() {
        if (!this.noRedstoneControl && RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v())) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.off.name");
        }
        if (this.getEnergyStoredGC() == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        return (Object)((Object)EnumColor.DARK_GREEN) + GCCoreUtil.translate("gui.status.active.name");
    }

    public String getGUIstatus(String missingInput, String activeString, boolean shorten) {
        if (!this.noRedstoneControl && RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v())) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.off.name");
        }
        if (this.getEnergyStoredGC() == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate(shorten ? "gui.status.missingpower.short.name" : "gui.status.missingpower.name");
        }
        if (missingInput != null) {
            return missingInput;
        }
        if (this.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate(shorten ? "gui.status.missingpower.short.name" : "gui.status.missingpower.name");
        }
        if (activeString != null) {
            return activeString;
        }
        return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.status.unknown.name");
    }
}

