/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.entities.layer;

import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.model.ModelPlayerGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.items.ItemThermalPaddingTier2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class LayerThermalPadding
extends LayerArmorBase<ModelBiped> {
    private final RenderPlayer renderer;

    public LayerThermalPadding(RenderPlayer playerRendererIn) {
        super((RendererLivingEntity)playerRendererIn);
        this.renderer = playerRendererIn;
    }

    public boolean func_177142_b() {
        return false;
    }

    public ItemStack func_177176_a(EntityLivingBase entitylivingbaseIn, int armorSlot) {
        int padding;
        PlayerGearData gearData = GalacticraftCore.proxy.getGearData((EntityPlayer)entitylivingbaseIn);
        if (gearData != null && (padding = gearData.getThermalPadding(armorSlot - 1)) != -1) {
            switch (padding) {
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return new ItemStack(AsteroidsItems.thermalPadding, 1, armorSlot);
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return new ItemStack(VenusItems.thermalPaddingTier2, 1, armorSlot);
                }
            }
        }
        return null;
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float f2, float f3, float partialTicks, float f5, float f6, float f7, float scale) {
        this.renderLayerGC(entitylivingbaseIn, f2, f3, partialTicks, f5, f6, f7, scale, 4);
        this.renderLayerGC(entitylivingbaseIn, f2, f3, partialTicks, f5, f6, f7, scale, 3);
        this.renderLayerGC(entitylivingbaseIn, f2, f3, partialTicks, f5, f6, f7, scale, 2);
        this.renderLayerGC(entitylivingbaseIn, f2, f3, partialTicks, f5, f6, f7, scale, 1);
    }

    private void renderLayerGC(EntityLivingBase entitylivingbaseIn, float f2, float f3, float partialTicks, float f5, float f6, float f7, float f8, int armorSlot) {
        ItemStack itemstack = this.func_177176_a(entitylivingbaseIn, armorSlot);
        if (itemstack != null) {
            ModelBiped t = this.func_177175_a(armorSlot);
            t.func_178686_a((ModelBase)this.renderer.func_177087_b());
            t.func_78086_a(entitylivingbaseIn, f2, f3, partialTicks);
            this.func_177179_a(t, armorSlot);
            this.renderer.func_110776_a(itemstack.func_77973_b() instanceof ItemThermalPaddingTier2 ? RenderPlayerGC.thermalPaddingTexture1_T2 : RenderPlayerGC.thermalPaddingTexture1);
            t.func_78088_a((Entity)entitylivingbaseIn, f2, f3, f5, f6, f7, f8);
            GlStateManager.func_179140_f();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderPlayerGC.thermalPaddingTexture0);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            float time = (float)entitylivingbaseIn.field_70173_aa / 10.0f;
            float sTime = (float)Math.sin(time) * 0.5f + 0.5f;
            float r = 0.2f * sTime;
            float g = 1.0f * sTime;
            float b = 0.2f * sTime;
            if (entitylivingbaseIn.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                float modifier = ((IGalacticraftWorldProvider)entitylivingbaseIn.field_70170_p.field_73011_w).getThermalLevelModifier();
                if (modifier > 0.0f) {
                    b = g;
                    g = r;
                } else if (modifier < 0.0f) {
                    r = g;
                    g = b;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(0.4f * sTime));
            t.func_78088_a((Entity)entitylivingbaseIn, f2, f3, f5, f6, f7, f8);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
        }
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelPlayerGC(0.9f, false);
        this.field_177186_d = new ModelPlayerGC(0.05f, false);
    }

    public ModelBiped func_177175_a(int slot) {
        return slot == 1 ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d;
    }

    protected void func_177179_a(ModelBiped model, int armorSlot) {
        model.func_178719_a(false);
        switch (armorSlot) {
            case 4: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case 3: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case 2: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case 1: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
            }
        }
    }
}

