/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.entities;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBuggy
extends Render<EntityBuggy> {
    private OBJModel.OBJBakedModel mainModel;
    private OBJModel.OBJBakedModel radarDish;
    private OBJModel.OBJBakedModel wheelLeftCover;
    private OBJModel.OBJBakedModel wheelRight;
    private OBJModel.OBJBakedModel wheelLeft;
    private OBJModel.OBJBakedModel wheelRightCover;
    private OBJModel.OBJBakedModel cargoLeft;
    private OBJModel.OBJBakedModel cargoMid;
    private OBJModel.OBJBakedModel cargoRight;

    private void updateModels() {
        if (this.mainModel == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galacticraftcore", "buggy.obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.mainModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"MainBody"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.radarDish = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"RadarDish_Dish"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.wheelLeftCover = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Left_Cover"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.wheelRight = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Right"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.wheelLeft = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Left"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.wheelRightCover = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Right_Cover"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.cargoLeft = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoLeft"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.cargoMid = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoMid"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.cargoRight = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoRight"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RenderBuggy(RenderManager manager) {
        super(manager);
        this.field_76989_e = 1.0f;
    }

    protected ResourceLocation getEntityTexture(EntityBuggy par1Entity) {
        return new ResourceLocation("missing");
    }

    public void doRender(EntityBuggy entity, double par2, double par4, double par6, float par8, float par9) {
        GL11.glPushMatrix();
        float var24 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * par9;
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(180.0f - par8), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-var24), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)0.41f, (float)0.41f, (float)0.41f);
        this.updateModels();
        RenderHelper.func_74518_a();
        this.func_110776_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        float rotation = entity.wheelRotationX;
        GL11.glPushMatrix();
        float dZ = -2.727f;
        float dY = 0.976f;
        float dX = 1.25f;
        GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
        GL11.glRotatef((float)entity.wheelRotationZ, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelRightCover);
        GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelRight);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-dX), (float)dY, (float)dZ);
        GL11.glRotatef((float)entity.wheelRotationZ, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelLeftCover);
        GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelLeft);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dX = 1.9f;
        dZ = -dZ;
        GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
        GL11.glRotatef((float)(-entity.wheelRotationZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelRight);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-dX), (float)dY, (float)dZ);
        GL11.glRotatef((float)(-entity.wheelRotationZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.wheelLeft);
        GL11.glPopMatrix();
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.mainModel);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.178f, (float)4.1f, (float)-2.397f);
        int ticks = entity.field_70173_aa + entity.func_145782_y() * 10000;
        GL11.glRotatef((float)((float)Math.sin((double)ticks * 0.05) * 50.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.cos((double)ticks * 0.1) * 50.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.radarDish);
        GL11.glPopMatrix();
        if (entity.buggyType > 0) {
            ClientUtil.drawBakedModel((IFlexibleBakedModel)this.cargoLeft);
            if (entity.buggyType > 1) {
                ClientUtil.drawBakedModel((IFlexibleBakedModel)this.cargoMid);
                if (entity.buggyType > 2) {
                    ClientUtil.drawBakedModel((IFlexibleBakedModel)this.cargoRight);
                }
            }
        }
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    public boolean shouldRender(EntityBuggy buggy, ICamera camera, double camX, double camY, double camZ) {
        AxisAlignedBB axisalignedbb = buggy.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0);
        return buggy.func_145770_h(camX, camY, camZ) && camera.func_78546_a(axisalignedbb);
    }
}

