/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.nei.BuggyRecipeHandler;
import micdoodle8.mods.galacticraft.core.client.nei.CircuitFabricatorRecipeHandler;
import micdoodle8.mods.galacticraft.core.client.nei.ElectricIngotCompressorRecipeHandler;
import micdoodle8.mods.galacticraft.core.client.nei.GCNEIHighlightHandler;
import micdoodle8.mods.galacticraft.core.client.nei.IngotCompressorRecipeHandler;
import micdoodle8.mods.galacticraft.core.client.nei.RefineryRecipeHandler;
import micdoodle8.mods.galacticraft.core.client.nei.RocketT1RecipeHandler;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;

public class NEIGalacticraftConfig
implements IConfigureNEI {
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> buggyBenchRecipes = new HashMap();
    private static HashMap<PositionedStack, PositionedStack> refineryRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> ingotCompressorRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        for (Item item : GCItems.hiddenItems) {
            API.hideItem((ItemStack)new ItemStack(item, 1, 0));
        }
        for (Block block : GCBlocks.hiddenBlocks) {
            API.hideItem((ItemStack)new ItemStack(block, 1, 0));
            if (block != GCBlocks.slabGCDouble) continue;
            for (int j = 1; j < (GalacticraftCore.isPlanetsLoaded ? 7 : 4); ++j) {
                API.hideItem((ItemStack)new ItemStack(block, 1, j));
            }
        }
        API.registerRecipeHandler((ICraftingHandler)new RocketT1RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT1RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BuggyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BuggyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new IngotCompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new IngotCompressorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ElectricIngotCompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ElectricIngotCompressorRecipeHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.basicBlock, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.blockMoon, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.fakeBlock, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightHandler((IHighlightHandler)new GCNEIHighlightHandler(), (ItemInfo.Layout[])new ItemInfo.Layout[]{ItemInfo.Layout.BODY});
    }

    public String getName() {
        return "Galacticraft NEI Plugin";
    }

    public String getVersion() {
        return "4.0.2";
    }

    public void registerIngotCompressorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        ingotCompressorRecipes.put(input, output);
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public void registerRocketBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerBuggyBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        buggyBenchRecipes.put(input, output);
    }

    public void registerRefineryRecipe(PositionedStack input, PositionedStack output) {
        refineryRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getIngotCompressorRecipes() {
        return ingotCompressorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getBuggyBenchRecipes() {
        return buggyBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getRefineryRecipes() {
        return refineryRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerRefineryRecipe(new PositionedStack((Object)new ItemStack(GCItems.oilCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 148, 3));
        this.addRocketRecipes();
        this.addBuggyRecipes();
        this.addCircuitFabricatorRecipes();
        this.addIngotCompressorRecipes();
    }

    private void addBuggyRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1 = new HashMap();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 0), 18, 37));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 0), 18, 91));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 0), 90, 37));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 0), 90, 91));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x == 1 && y == 1) {
                    input1.put(y * 3 + x + 4, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 1), 36 + x * 18, 37 + y * 18));
                    continue;
                }
                input1.put(y * 3 + x + 4, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36 + x * 18, 37 + y * 18));
            }
        }
        this.registerBuggyBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 0), 139, 101));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(17, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(18, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(17, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(17, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(17, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 3), 139, 101));
    }

    private void addRocketRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 45, 15));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 33));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 51));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 69));
        input1.put(4, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 87));
        input1.put(5, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 33));
        input1.put(6, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 51));
        input1.put(7, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 69));
        input1.put(8, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 87));
        input1.put(9, new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 45, 105));
        input1.put(10, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 87));
        input1.put(11, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 105));
        input1.put(12, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 87));
        input1.put(13, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 105));
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 0), 139, 92));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 3), 139, 92));
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount];
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j] = (ItemStack)OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).get(j);
        }
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150429_aA), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 5 : 3, 13), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151100_aR, 1, 4), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 9, 12), 147, 91));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 2 : 1, 14), 147, 91));
    }

    private void addIngotCompressorRecipes() {
        for (int i = 0; i < CompressorRecipes.getRecipeList().size(); ++i) {
            int j;
            Object recipe;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            IRecipe rec = CompressorRecipes.getRecipeList().get(i);
            if (rec instanceof ShapedRecipesGC) {
                recipe = (ShapedRecipesGC)rec;
                for (j = 0; j < ((ShapedRecipesGC)recipe).recipeItems.length; ++j) {
                    ItemStack stack = ((ShapedRecipesGC)recipe).recipeItems[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessOreRecipeGC) {
                recipe = (ShapelessOreRecipeGC)rec;
                for (j = 0; j < ((ShapelessOreRecipeGC)recipe).getInput().size(); ++j) {
                    Object obj = ((ShapelessOreRecipeGC)recipe).getInput().get(j);
                    input1.put(j, new PositionedStack(obj, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            ItemStack resultItemStack = rec.func_77571_b().func_77946_l();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.field_77994_a *= 2;
            }
            this.registerIngotCompressorRecipe(input1, new PositionedStack((Object)resultItemStack, 140, 46));
        }
    }
}

