/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapelessRecipeWrapper;
import micdoodle8.mods.galacticraft.core.util.GCLog;

public class IngotCompressorShapelessRecipeHandler
implements IRecipeHandler<ShapelessOreRecipeGC> {
    @Nonnull
    public Class<ShapelessOreRecipeGC> getRecipeClass() {
        return ShapelessOreRecipeGC.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "galacticraft.ingotcompressor";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull ShapelessOreRecipeGC recipe) {
        return new IngotCompressorShapelessRecipeWrapper(recipe);
    }

    public boolean isRecipeValid(@Nonnull ShapelessOreRecipeGC recipe) {
        if (recipe.func_77571_b() == null) {
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has no outputs!");
            return false;
        }
        int inputCount = 0;
        for (Object input : recipe.getInput()) {
            if (input instanceof List && ((List)input).size() == 0) {
                GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has an empty list as an input!");
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount > 9) {
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has too many inputs!");
            return false;
        }
        if (inputCount == 0) {
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has no inputs!");
            return false;
        }
        return true;
    }
}

