/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor;

import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapedRecipeWrapper;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.item.ItemStack;

public class IngotCompressorShapedRecipeHandler
implements IRecipeHandler<ShapedRecipesGC> {
    @Nonnull
    public Class<ShapedRecipesGC> getRecipeClass() {
        return ShapedRecipesGC.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "galacticraft.ingotcompressor";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull ShapedRecipesGC recipe) {
        return new IngotCompressorShapedRecipeWrapper(recipe);
    }

    public boolean isRecipeValid(@Nonnull ShapedRecipesGC recipe) {
        if (recipe.func_77571_b() == null) {
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has no output!");
            return false;
        }
        int inputCount = 0;
        for (ItemStack input : recipe.recipeItems) {
            if (input instanceof ItemStack) {
                ++inputCount;
                continue;
            }
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has input that is not an ItemStack!");
            return false;
        }
        if (inputCount > 9) {
            GCLog.severe(this.getClass().getSimpleName() + " JEI recipe has too many inputs!");
            return false;
        }
        return inputCount > 0;
    }
}

