/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapedRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapelessRecipeWrapper;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class IngotCompressorRecipeCategory
extends BlankRecipeCategory {
    private static final ResourceLocation compressorTex = new ResourceLocation("galacticraftcore", "textures/gui/ingot_compressor.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated progressBar;

    public IngotCompressorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(compressorTex, 18, 17, 137, 78);
        this.localizedName = GCCoreUtil.translate("tile.machine.3.name");
        IDrawableStatic progressBarDrawable = guiHelper.createDrawable(compressorTex, 176, 13, 52, 17);
        this.progressBar = guiHelper.createAnimatedDrawable(progressBarDrawable, 70, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "galacticraft.ingotcompressor";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.progressBar.draw(minecraft, 59, 20);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup itemstacks = recipeLayout.getItemStacks();
        for (int j = 0; j < 9; ++j) {
            itemstacks.init(j, true, j % 3 * 18, j / 3 * 18);
        }
        itemstacks.init(9, false, 119, 20);
        if (recipeWrapper instanceof IngotCompressorShapedRecipeWrapper) {
            IngotCompressorShapedRecipeWrapper ingotCompressorRecipeWrapper = (IngotCompressorShapedRecipeWrapper)recipeWrapper;
            List inputs = ingotCompressorRecipeWrapper.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                Object o = inputs.get(i);
                if (o == null) continue;
                itemstacks.setFromRecipe(i, o);
            }
            itemstacks.setFromRecipe(9, ingotCompressorRecipeWrapper.getOutputs());
        } else if (recipeWrapper instanceof IngotCompressorShapelessRecipeWrapper) {
            IngotCompressorShapelessRecipeWrapper ingotCompressorRecipeWrapper = (IngotCompressorShapelessRecipeWrapper)recipeWrapper;
            List inputs = ingotCompressorRecipeWrapper.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                Object o = inputs.get(i);
                if (o == null) continue;
                itemstacks.setFromRecipe(i, o);
            }
            itemstacks.setFromRecipe(9, ingotCompressorRecipeWrapper.getOutputs());
        }
    }
}

