/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeWrapper;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CircuitFabricatorRecipeCategory
extends BlankRecipeCategory {
    private static final ResourceLocation circuitFabTex = new ResourceLocation("galacticraftcore", "textures/gui/circuit_fabricator.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated progressBar;

    public CircuitFabricatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(circuitFabTex, 3, 4, 168, 101);
        this.localizedName = GCCoreUtil.translate("tile.machine2.5.name");
        IDrawableStatic progressBarDrawable = guiHelper.createDrawable(circuitFabTex, 176, 17, 51, 10);
        this.progressBar = guiHelper.createAnimatedDrawable(progressBarDrawable, 70, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "galacticraft.circuits";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.progressBar.draw(minecraft, 85, 16);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup itemstacks = recipeLayout.getItemStacks();
        itemstacks.init(0, true, 11, 12);
        itemstacks.init(1, true, 70, 41);
        itemstacks.init(2, true, 70, 59);
        itemstacks.init(3, true, 118, 41);
        itemstacks.init(4, true, 141, 15);
        itemstacks.init(5, false, 148, 81);
        if (recipeWrapper instanceof CircuitFabricatorRecipeWrapper) {
            CircuitFabricatorRecipeWrapper circuitFabricatorRecipeWrapper = (CircuitFabricatorRecipeWrapper)recipeWrapper;
            List inputs = circuitFabricatorRecipeWrapper.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                Object o = inputs.get(i);
                if (o == null) continue;
                itemstacks.setFromRecipe(i, o);
            }
            itemstacks.setFromRecipe(5, circuitFabricatorRecipeWrapper.getOutputs());
        }
    }
}

