/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public abstract class BlockTransmitter
extends BlockAdvanced {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockTransmitter(Material material) {
        super(material);
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        TileEntity tile = worldIn.func_175625_s(pos);
        this.func_180654_a((IBlockAccess)worldIn, pos);
        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_WIRE_BOUNDS, GCCoreUtil.getDimensionID(worldIn), new Object[]{pos}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(worldIn), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0));
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tile instanceof INetworkConnection) {
            ((INetworkConnection)tile).refresh();
        }
    }

    public abstract Vector3 getMinVector(IBlockState var1);

    public abstract Vector3 getMaxVector(IBlockState var1);

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180640_a(worldIn, pos, state);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        IBlockState bs = worldIn.func_180495_p(pos);
        if (tileEntity instanceof ITransmitter && bs.func_177230_c() instanceof BlockTransmitter) {
            Vector3 minVector = this.getMinVector(bs);
            Vector3 maxVector = this.getMaxVector(bs);
            TileEntity[] connectable = new TileEntity[6];
            switch (this.getNetworkType(bs)) {
                case FLUID: {
                    connectable = OxygenUtil.getAdjacentFluidConnections(tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
            }
            float minX = (float)minVector.x;
            float minY = (float)minVector.y;
            float minZ = (float)minVector.z;
            float maxX = (float)maxVector.x;
            float maxY = (float)maxVector.y;
            float maxZ = (float)maxVector.z;
            if (connectable[0] != null) {
                minY = 0.0f;
            }
            if (connectable[1] != null) {
                maxY = 1.0f;
            }
            if (connectable[2] != null) {
                minZ = 0.0f;
            }
            if (connectable[3] != null) {
                maxZ = 1.0f;
            }
            if (connectable[4] != null) {
                minX = 0.0f;
            }
            if (connectable[5] != null) {
                maxX = 1.0f;
            }
            this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public abstract NetworkType getNetworkType(IBlockState var1);

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        Vector3 minVector = this.getMinVector(state);
        Vector3 maxVector = this.getMaxVector(state);
        this.func_149676_a((float)minVector.x, (float)minVector.y, (float)minVector.z, (float)maxVector.x, (float)maxVector.y, (float)maxVector.z);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof ITransmitter) {
            TileEntity[] connectable;
            switch (this.getNetworkType(state)) {
                case FLUID: {
                    connectable = OxygenUtil.getAdjacentFluidConnections(tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
                default: {
                    connectable = new TileEntity[6];
                }
            }
            if (connectable[4] != null) {
                this.func_149676_a(0.0f, (float)minVector.y, (float)minVector.z, (float)maxVector.x, (float)maxVector.y, (float)maxVector.z);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            if (connectable[5] != null) {
                this.func_149676_a((float)minVector.x, (float)minVector.y, (float)minVector.z, 1.0f, (float)maxVector.y, (float)maxVector.z);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            if (connectable[0] != null) {
                this.func_149676_a((float)minVector.x, 0.0f, (float)minVector.z, (float)maxVector.x, (float)maxVector.y, (float)maxVector.z);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            if (connectable[1] != null) {
                this.func_149676_a((float)minVector.x, (float)minVector.y, (float)minVector.z, (float)maxVector.x, 1.0f, (float)maxVector.z);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            if (connectable[2] != null) {
                this.func_149676_a((float)minVector.x, (float)minVector.y, 0.0f, (float)maxVector.x, (float)maxVector.y, (float)maxVector.z);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            if (connectable[3] != null) {
                this.func_149676_a((float)minVector.x, (float)minVector.y, (float)minVector.z, (float)maxVector.x, (float)maxVector.y, 1.0f);
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof ITransmitter) {
            TileEntity[] connectable = new TileEntity[6];
            switch (this.getNetworkType(state)) {
                case FLUID: {
                    connectable = OxygenUtil.getAdjacentFluidConnections(tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
            }
            return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(connectable[EnumFacing.DOWN.ordinal()] != null)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(connectable[EnumFacing.UP.ordinal()] != null)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.NORTH.ordinal()] != null)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(connectable[EnumFacing.EAST.ordinal()] != null)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.SOUTH.ordinal()] != null)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(connectable[EnumFacing.WEST.ordinal()] != null));
        }
        return state;
    }
}

