/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockTelemetry
extends BlockAdvancedTile
implements IShiftDescription,
ISortableBlock {
    public BlockTelemetry(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 4;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 5;
            }
        }
        worldIn.func_180501_a(pos, this.func_176203_a(change), 3);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        int facing = metadata & 3;
        int change = 0;
        switch (facing) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 3;
                break;
            }
            case 2: {
                change = 5;
                break;
            }
            case 3: {
                change = 4;
                break;
            }
            case 4: {
                change = 2;
                break;
            }
            case 5: {
                change = 0;
            }
        }
        world.func_180501_a(pos, this.func_176203_a(change += 0xC & metadata), 2);
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTelemetry();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityTelemetry) {
            ItemStack held = entityPlayer.field_71071_by.func_70448_g();
            if (held != null && held.func_77973_b() == GCItems.basicItem && held.func_77952_i() == 19) {
                NBTTagCompound fmData = held.func_77978_p();
                if (fmData != null && fmData.func_74764_b("linkedUUIDMost") && fmData.func_74764_b("linkedUUIDLeast")) {
                    UUID uuid = new UUID(fmData.func_74763_f("linkedUUIDMost"), fmData.func_74763_f("linkedUUIDLeast"));
                    ((TileEntityTelemetry)tile).addTrackedEntity(uuid);
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetry_succeed.message")));
                } else {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetry_fail.message")));
                    if (fmData == null) {
                        fmData = new NBTTagCompound();
                        held.func_77982_d(fmData);
                    }
                }
                fmData.func_74768_a("teCoordX", pos.func_177958_n());
                fmData.func_74768_a("teCoordY", pos.func_177956_o());
                fmData.func_74768_a("teCoordZ", pos.func_177952_p());
                fmData.func_74768_a("teDim", GCCoreUtil.getDimensionID(world));
                return true;
            }
            ItemStack wearing = GCPlayerStats.get((Entity)entityPlayer).getFrequencyModuleInSlot();
            if (wearing != null) {
                if (wearing.func_77942_o() && wearing.func_77978_p().func_74764_b("teDim")) {
                    return false;
                }
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetry_fail_wearing_it.message")));
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetry_fail_no_frequency_module.message")));
            }
        }
        return false;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

