/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpinThruster
extends BlockAdvanced
implements IShiftDescription,
ITileEntityProvider,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSpinThruster(String assetName) {
        super(Material.field_151594_q);
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST, true) || world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST, true) || world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH, true) || world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH, true);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.func_176740_k().func_176722_c() && this.canBlockStay(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canBlockStay(world, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == 0) {
            this.func_176213_c(worldIn, pos, state);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos baseBlock;
        int metadata = this.func_176201_c(state);
        switch (metadata) {
            case 1: {
                baseBlock = pos.func_177972_a(EnumFacing.WEST);
                break;
            }
            case 2: {
                baseBlock = pos.func_177972_a(EnumFacing.EAST);
                break;
            }
            case 3: {
                baseBlock = pos.func_177972_a(EnumFacing.NORTH);
                break;
            }
            case 4: {
                baseBlock = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            default: {
                return;
            }
        }
        if (!worldIn.field_72995_K && worldIn.field_73011_w instanceof WorldProviderSpaceStation) {
            ((WorldProviderSpaceStation)worldIn.field_73011_w).getSpinManager().refresh(baseBlock, true);
        }
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!this.canBlockStay(world, pos, enumfacing)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        if (!world.field_72995_K && world.field_73011_w instanceof WorldProviderSpaceStation) {
            ((WorldProviderSpaceStation)world.field_73011_w).getSpinManager().refresh(pos, true);
        }
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing facing) {
        return world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true);
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        float var8 = 0.3f;
        EnumFacing facing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockMachine.FACING);
        switch (facing) {
            case NORTH: {
                this.func_149676_a(0.5f - var8, 0.2f, 1.0f - var8 * 2.0f, 0.5f + var8, 0.8f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, 0.2f, 0.5f - var8, var8 * 2.0f, 0.8f, 0.5f + var8);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.5f - var8, 0.2f, 0.0f, 0.5f + var8, 0.8f, var8 * 2.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(1.0f - var8 * 2.0f, 0.2f, 0.5f - var8, 1.0f, 0.8f, 0.5f + var8);
                break;
            }
        }
        return super.func_180636_a(worldIn, pos, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_73011_w instanceof WorldProviderSpaceStation && (((WorldProviderSpaceStation)worldIn.field_73011_w).getSpinManager().thrustersFiring || rand.nextInt(80) == 0)) {
            int var6 = this.func_176201_c(state) & 7;
            double var7 = (float)pos.func_177958_n() + 0.5f;
            double var9 = (float)pos.func_177956_o() + 0.7f;
            double var11 = (float)pos.func_177952_p() + 0.5f;
            double var13 = 0.22f;
            double var15 = 0.27f;
            if (var6 == 1) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var7 - (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0, new int[0]);
            } else if (var6 == 2) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var7 + (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0, new int[0]);
            } else if (var6 == 3) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var7, var9 + (double)0.22f, var11 - (double)0.27f, 0.0, 0.0, 0.0, new int[0]);
            } else if (var6 == 4) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var7, var9 + (double)0.22f, var11 + (double)0.27f, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing currentFacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        EnumFacing nextFacing = currentFacing.func_176746_e();
        while (true) {
            if (this.canBlockStay(world, pos.func_177972_a(nextFacing.func_176734_d()), nextFacing)) {
                world.func_180501_a(pos, this.func_176203_a(nextFacing.func_176736_b()), 2);
                break;
            }
            if (nextFacing == currentFacing) break;
            nextFacing = nextFacing.func_176746_e();
        }
        if (world.field_73011_w instanceof WorldProviderSpaceStation && !world.field_72995_K) {
            WorldProviderSpaceStation worldOrbital = (WorldProviderSpaceStation)world.field_73011_w;
            worldOrbital.getSpinManager().refresh(pos, true);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityThruster();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            int facing = this.func_176201_c(state) & 8;
            if (worldIn.field_73011_w instanceof WorldProviderSpaceStation) {
                WorldProviderSpaceStation worldOrbital = (WorldProviderSpaceStation)worldIn.field_73011_w;
                worldOrbital.getSpinManager().removeThruster(pos, facing == 0);
                worldOrbital.getSpinManager().updateSpinSpeed();
            }
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

