/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockScreen
extends BlockAdvanced
implements IShiftDescription,
IPartialSealableBlock,
ITileEntityProvider,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockScreen(String assetName) {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c(assetName);
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        return direction.ordinal() != this.func_176201_c(world.func_180495_p(pos));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ((TileEntityScreen)worldIn.func_175625_s(pos)).breakScreen(state);
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176745_a();
        worldIn.func_180501_a(pos, this.func_176203_a(change), 3);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176746_e().func_176745_a();
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityScreen();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityScreen) {
            ((TileEntityScreen)tile).changeChannel();
            return true;
        }
        return false;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityScreen) {
            ((TileEntityScreen)tile).refreshConnections(true);
        }
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        return true;
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        int metadata = this.func_176201_c(worldIn.func_180495_p(pos)) & 7;
        float boundsFront = 0.094f;
        float boundsBack = 1.0f - boundsFront;
        switch (metadata) {
            case 0: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, boundsBack, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, boundsFront, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, boundsFront, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, boundsBack);
                break;
            }
            case 4: {
                this.func_149676_a(boundsFront, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, boundsBack, 1.0f, 1.0f);
            }
        }
        return super.func_180636_a(worldIn, pos, start, end);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, LEFT, RIGHT, UP, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityScreen screen = (TileEntityScreen)worldIn.func_175625_s(pos);
        return state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(screen.connectedLeft)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(screen.connectedRight)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(screen.connectedUp)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(screen.connectedDown));
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

