/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPlatform;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlatform
extends BlockAdvancedTile
implements IPartialSealableBlock,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumCorner> CORNER = PropertyEnum.func_177709_a((String)"type", EnumCorner.class);
    public static final float HEIGHT = 0.875f;
    public static boolean ignoreCollisionTests;

    public BlockPlatform(String assetName) {
        super(Material.field_151573_f);
        this.func_149676_a(0.0f, 0.375f, 0.0f, 1.0f, 0.875f, 1.0f);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CORNER, (Comparable)((Object)EnumCorner.NONE)));
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    private boolean checkAxis(World worldIn, BlockPos pos, Block block, EnumFacing facing) {
        int sameCount = 0;
        for (int i = 1; i <= 2; ++i) {
            IBlockState bs = worldIn.func_180495_p(pos.func_177967_a(facing, i));
            if (bs.func_177230_c() != block || bs.func_177229_b(CORNER) != EnumCorner.NONE) continue;
            ++sameCount;
        }
        return sameCount > 1;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        Block id = GCBlocks.platform;
        if (this.checkAxis(worldIn, pos, id, EnumFacing.EAST) || this.checkAxis(worldIn, pos, id, EnumFacing.WEST) || this.checkAxis(worldIn, pos, id, EnumFacing.NORTH) || this.checkAxis(worldIn, pos, id, EnumFacing.SOUTH)) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == GCBlocks.platform && side == EnumFacing.UP) {
            return false;
        }
        return this.func_176196_c(worldIn, pos);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPlatform(meta);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity var9 = worldIn.func_175625_s(pos);
        if (var9 instanceof TileEntityPlatform) {
            ((TileEntityPlatform)var9).onDestroy(var9);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        return direction == EnumFacing.UP;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CORNER, (Comparable)((Object)EnumCorner.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCorner)((Object)state.func_177229_b(CORNER))).getMeta();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{CORNER});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (ignoreCollisionTests) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityPlatform && ((TileEntityPlatform)te).noCollide()) {
            return;
        }
        AxisAlignedBB axisalignedbb = this.func_180640_a(worldIn, pos, state);
        if (axisalignedbb != null && mask.func_72326_a(axisalignedbb)) {
            list.add(axisalignedbb);
        }
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        double top = (double)pos.func_177956_o() + (worldIn.field_73011_w instanceof IZeroGDimension ? 1.0 : this.field_149756_F);
        return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + this.field_149755_E, top, (double)pos.func_177952_p() + this.field_149757_G);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityPlatform && ((TileEntityPlatform)te).noCollide()) {
            IBlockState bs = worldIn.func_180495_p(pos);
            if (bs.func_177230_c() == this && bs.func_177229_b(CORNER) == EnumCorner.SE) {
                return new AxisAlignedBB((double)pos.func_177958_n() + 0.5625, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + 0.5625, (double)pos.func_177958_n() + this.field_149755_E, (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + this.field_149757_G);
            }
            return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + 0.4375, (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + 0.4375);
        }
        return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + this.field_149755_E, (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + this.field_149757_G);
    }

    public static enum EnumCorner implements IStringSerializable
    {
        NONE(0, "none"),
        NW(1, "sw"),
        SW(2, "nw"),
        NE(3, "se"),
        SE(4, "ne");

        private final int meta;
        private final String name;
        private static final EnumCorner[] values;

        private EnumCorner(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumCorner byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumCorner.values();
        }
    }
}

