/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IPaintable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPanelLight;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PropertyObject;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPanelLighting
extends BlockAdvancedTile
implements ISortableBlock,
IShiftDescription,
IPaintable {
    public static final PropertyEnum<PanelType> TYPE = PropertyEnum.func_177709_a((String)"type", PanelType.class);
    public static final PropertyObject<IBlockState> BASE_STATE = new PropertyObject<IBlockState>("held_state", IBlockState.class);
    public static int color = 0xF0F0E0;
    public static final int PANELTYPES_LENGTH = PanelType.values().length;
    private static IBlockState[] superState = new IBlockState[PANELTYPES_LENGTH];

    public BlockPanelLighting(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE}, new IUnlistedProperty[]{BASE_STATE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < PANELTYPES_LENGTH; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(new ItemStack(this.func_180660_a(state, null, fortune), 1, this.func_176201_c(state)));
        return result;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int damage, EntityLivingBase placer) {
        return this.func_176203_a(damage);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        int damage = stack.func_77952_i();
        if (damage >= PANELTYPES_LENGTH) {
            damage = 0;
        }
        if ((tile = worldIn.func_175625_s(pos)) instanceof TileEntityPanelLight && placer instanceof EntityPlayer) {
            BlockPanelLighting cfr_ignored_0 = (BlockPanelLighting)state.func_177230_c();
            ((TileEntityPanelLight)tile).initialise(damage, BlockPistonBase.func_180695_a((World)worldIn, (BlockPos)pos, (EntityLivingBase)placer), (EntityPlayer)placer, worldIn.field_72995_K, superState[damage]);
        }
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityPanelLight)) {
            return false;
        }
        IBlockState bs = world.func_180495_p(pos);
        if (!(bs.func_177230_c() instanceof BlockPanelLighting)) {
            return false;
        }
        PanelType type = (PanelType)((Object)bs.func_177229_b(TYPE));
        TileEntityPanelLight tilegood = (TileEntityPanelLight)tile;
        int metadata = tilegood.meta;
        if (metadata < 8 && (type == PanelType.LINEAR || type == PanelType.SF) || metadata < 24 && type == PanelType.SFDIAG) {
            tilegood.meta += 8;
            return true;
        }
        int metaDir = ((metadata & 7) + 1) % 6;
        if (metaDir == 3) {
            metaDir = 5;
        } else if (metaDir == 0) {
            metaDir = 3;
        } else if (metaDir == 5) {
            metaDir = 0;
        }
        tilegood.meta = metaDir;
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPanelLight();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate("tile.panel_lighting.description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= PANELTYPES_LENGTH) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)PanelType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((PanelType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPanelLight) {
            state = ((IExtendedBlockState)state).withProperty(BASE_STATE, (Object)((TileEntityPanelLight)tile).getBaseBlock());
        }
        return state;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        if (!(bs.func_177230_c() instanceof BlockPanelLighting)) {
            return 0;
        }
        if (world instanceof World && RedstoneUtil.isBlockReceivingRedstone((World)world, pos)) {
            return 0;
        }
        return ((PanelType)((Object)bs.func_177229_b(TYPE))).getLight();
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        worldIn.func_180500_c(EnumSkyBlock.BLOCK, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateClient(int type, IBlockState state) {
        if (type >= PANELTYPES_LENGTH) {
            type = 0;
        }
        BlockPanelLighting.superState[type] = state;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateClient(List<Object> data) {
        for (int i = 0; i < PANELTYPES_LENGTH; ++i) {
            IBlockState state = TileEntityPanelLight.readBlockState((String)data.get(i + i + 1), (Integer)data.get(i + i + 2));
            if (state.func_177230_c() == Blocks.field_150350_a) {
                state = null;
            }
            BlockPanelLighting.superState[i] = state;
        }
        color = (Integer)data.get(2 * PANELTYPES_LENGTH + 1);
    }

    public static void getNetworkedData(Object[] result, IBlockState[] panel_lighting) {
        for (int i = 0; i < PANELTYPES_LENGTH; ++i) {
            IBlockState bs = panel_lighting[i];
            if (bs == null) {
                bs = Blocks.field_150350_a.func_176223_P();
            }
            Block block = bs.func_177230_c();
            result[i + i + 1] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            result[i + i + 2] = block.func_176201_c(bs);
        }
    }

    @Override
    public int setColor(int color, EntityPlayer p, Side side) {
        if (side == Side.CLIENT) {
            BlockPanelLighting.color = ColorUtil.lighten(ColorUtil.lightenFully(color, 255), 0.1f);
        } else {
            GCPlayerStats stats = GCPlayerStats.get((Entity)p);
            stats.setPanelLightingColor(color);
        }
        return 1;
    }

    public static enum PanelType implements IStringSerializable
    {
        SQUARE("square", 11),
        SPOTS("spots", 7),
        LINEAR("linear", 9),
        SF("sf", 2),
        SFDIAG("sfdiag", 2);

        private final String name;
        private final int light;

        private PanelType(String name, int lightValue) {
            this.name = name;
            this.light = lightValue;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }
    }
}

