/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOxygenCollector
extends BlockAdvancedTile
implements IShiftDescription,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockOxygenCollector(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock(state, world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityOxygenCollector();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a(change), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityOxygenCollector && ((TileEntityOxygenCollector)tile).lastOxygenCollected > 1.0f) {
            for (int particleCount = 0; particleCount < 10; ++particleCount) {
                double x2 = (float)pos.func_177958_n() + rand.nextFloat();
                double y2 = (float)pos.func_177956_o() + rand.nextFloat();
                double z2 = (float)pos.func_177952_p() + rand.nextFloat();
                double mX = 0.0;
                double mY = 0.0;
                double mZ = 0.0;
                int dir = rand.nextInt(2) * 2 - 1;
                mX = ((double)rand.nextFloat() - 0.5) * 0.5;
                mY = ((double)rand.nextFloat() - 0.5) * 0.5;
                mZ = ((double)rand.nextFloat() - 0.5) * 0.5;
                int meta = this.func_176201_c(state);
                if (meta == 3 || meta == 2) {
                    x2 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)dir;
                    mX = rand.nextFloat() * 2.0f * (float)dir;
                } else {
                    z2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)dir;
                    mZ = rand.nextFloat() * 2.0f * (float)dir;
                }
                GalacticraftCore.proxy.spawnParticle("oxygen", new Vector3(x2, y2, z2), new Vector3(mX, mY, mZ), new Object[]{new Vector3(0.7, 0.7, 1.0)});
            }
        }
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

