/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMulti
extends BlockAdvanced
implements IPartialSealableBlock,
ITileEntityProvider {
    public static final PropertyEnum<EnumBlockMultiType> MULTI_TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockMultiType.class);
    public static final PropertyInteger RENDER_TYPE = PropertyInteger.func_177719_a((String)"renderType", (int)0, (int)7);

    public BlockMulti(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
        this.func_149752_b(1.0E15f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        int meta = this.func_176201_c(worldIn.func_180495_p(pos));
        if (meta == 2 || meta == 6) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
        } else if (meta == 0 || meta == 4) {
            boolean topPole;
            boolean midPole = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            boolean bl = topPole = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
            if (topPole || midPole) {
                this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, midPole ? 1.0f : 0.6f, 0.7f);
            } else {
                this.func_149676_a(0.0f, 0.2f, 0.0f, 1.0f, 0.8f, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        int meta = this.func_176201_c(state);
        if (meta == 2 || meta == 6) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        } else if (meta == 0 || meta == 4) {
            this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this ? 1.0f : 0.6f, 0.7f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        } else {
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180640_a(worldIn, pos, state);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public void makeFakeBlock(World worldObj, BlockPos pos, BlockPos mainBlock, int meta) {
        worldObj.func_180501_a(pos, GCBlocks.fakeBlock.func_176203_a(meta), meta == 5 ? 3 : 0);
        worldObj.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
    }

    public void makeFakeBlock(World worldObj, Collection<BlockPos> posList, BlockPos mainBlock, EnumBlockMultiType type) {
        for (BlockPos pos : posList) {
            worldObj.func_180501_a(pos, this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)type)), type == EnumBlockMultiType.CRYO_CHAMBER ? 3 : 0);
            worldObj.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
        }
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return worldIn.func_180495_p(mainBlockPosition).func_177230_c().func_176195_g(worldIn, pos);
        }
        return this.field_149782_v;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        int metadata = this.func_176201_c(worldIn.func_180495_p(pos));
        if (metadata == 2 || metadata == 6) {
            return direction == EnumFacing.DOWN;
        }
        if (metadata == 4) {
            return direction == EnumFacing.UP;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti) {
            ((TileEntityMulti)tileEntity).onBlockRemoval();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.onBlockActivated(worldIn, pos, playerIn);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)world.func_175625_s(pos);
        return tileEntity.onBlockWrenched(world, pos, entityPlayer, side, hitX, hitY, hitZ);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        Block mainBlockID;
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos) && Blocks.field_150350_a != (mainBlockID = world.func_180495_p(mainBlockPosition).func_177230_c())) {
            return mainBlockID.getPickBlock(target, world, mainBlockPosition, player);
        }
        return null;
    }

    public EnumFacing getBedDirection(IBlockAccess world, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return world.func_180495_p(mainBlockPosition).func_177230_c().getBedDirection(world, mainBlockPosition);
        }
        return EnumFacing.UP;
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, Entity player) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return world.func_180495_p(mainBlockPosition).func_177230_c().isBed(world, mainBlockPosition, player);
        }
        return super.isBed(world, pos, player);
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        TileEntity tileEntity = world.func_175625_s(pos);
        BlockPos mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition;
        if (mainBlockPosition != null && !mainBlockPosition.equals((Object)pos)) {
            world.func_180495_p(mainBlockPosition).func_177230_c().setBedOccupied(world, mainBlockPosition, player, occupied);
        } else {
            super.setBedOccupied(world, pos, player, occupied);
        }
    }

    public BlockPos getBedSpawnPosition(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (!(world instanceof World)) {
            return null;
        }
        int tries = 3;
        World worldIn = (World)world;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        BlockPos mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition;
        IBlockState cryoChamber = worldIn.func_180495_p(mainBlockPosition);
        EnumFacing enumfacing = EnumFacing.NORTH;
        if (GalacticraftCore.isPlanetsLoaded && cryoChamber.func_177230_c() == MarsBlocks.machine) {
            enumfacing = (EnumFacing)cryoChamber.func_177229_b((IProperty)BlockMachineMars.FACING);
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockMulti.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    private static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b()) && !worldIn.func_180495_p(pos).func_177230_c().func_149688_o().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o().func_76220_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = worldObj.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)target.func_178782_a())) {
            effectRenderer.addBlockHitEffects(mainBlockPosition, target);
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        return super.addDestroyEffects(world, pos, effectRenderer);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)EnumBlockMultiType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE))).getMeta();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{MULTI_TYPE, RENDER_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumBlockMultiType type = (EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE));
        int renderType = 0;
        switch (type) {
            case CRYO_CHAMBER: {
                IBlockState stateMain;
                IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
                TileEntityMulti tile = (TileEntityMulti)worldIn.func_175625_s(pos);
                renderType = stateAbove.func_177230_c() == this && stateAbove.func_177229_b(MULTI_TYPE) == EnumBlockMultiType.CRYO_CHAMBER ? 0 : 4;
                if (tile == null || tile.mainBlockPosition == null || !GalacticraftCore.isPlanetsLoaded || (stateMain = worldIn.func_180495_p(tile.mainBlockPosition)).func_177230_c() != MarsBlocks.machine || stateMain.func_177229_b((IProperty)BlockMachineMars.TYPE) != BlockMachineMars.EnumMachineType.CRYOGENIC_CHAMBER) break;
                EnumFacing dir = (EnumFacing)stateMain.func_177229_b((IProperty)BlockMachineMars.FACING);
                renderType += dir.func_176736_b();
                break;
            }
        }
        return state.func_177226_a((IProperty)RENDER_TYPE, (Comparable)Integer.valueOf(renderType));
    }

    public static void onPlacement(World worldIn, BlockPos pos, EntityLivingBase placer, Block callingBlock) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IMultiBlock) {
            boolean validSpot = true;
            LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
            ((IMultiBlock)tile).getPositions(pos, toCheck);
            for (BlockPos toTest : toCheck) {
                IBlockState blockAt = worldIn.func_180495_p(toTest);
                if (blockAt.func_177230_c().func_176200_f(worldIn, toTest)) continue;
                validSpot = false;
                break;
            }
            if (!validSpot) {
                worldIn.func_175698_g(pos);
                if (!worldIn.field_72995_K && placer instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)placer;
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.warning.noroom")));
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack nasaWorkbench = new ItemStack(callingBlock, 1, 0);
                        EntityItem entityitem = player.func_71019_a(nasaWorkbench, false);
                        entityitem.func_174867_a(0);
                        entityitem.func_145797_a(player.func_70005_c_());
                    }
                }
                return;
            }
            ((IMultiBlock)tile).onCreate(worldIn, pos);
        }
    }

    public static enum EnumBlockMultiType implements IStringSerializable
    {
        SOLAR_PANEL_0(0, "solar"),
        SPACE_STATION_BASE(1, "ss_base"),
        ROCKET_PAD(2, "rocket_pad"),
        NASA_WORKBENCH(3, "nasa_workbench"),
        SOLAR_PANEL_1(4, "solar_panel"),
        CRYO_CHAMBER(5, "cryo_chamber"),
        BUGGY_FUEL_PAD(6, "buggy_pad"),
        MINER_BASE(7, "miner_base"),
        DISH_LARGE(8, "dish_large");

        private final int meta;
        private final String name;
        private static final EnumBlockMultiType[] values;

        private EnumBlockMultiType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockMultiType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumBlockMultiType.values();
        }
    }
}

