/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachineTiered
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final int STORAGE_MODULE_METADATA = 0;
    public static final int ELECTRIC_FURNACE_METADATA = 4;
    public static IMachineSidesProperties MACHINESIDES_RENDERTYPE = IMachineSidesProperties.TWOFACES_HORIZ;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumTieredMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumTieredMachineType.class);
    public static final PropertyInteger FILL_VALUE = PropertyInteger.func_177719_a((String)"fill_value", (int)0, (int)33);
    public static final PropertyEnum SIDES = BlockMachineTiered.MACHINESIDES_RENDERTYPE.asProperty;

    public BlockMachineTiered(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        if (metadata >= 12) {
            worldIn.func_180501_a(pos, this.func_176203_a(12 + change), 3);
        } else if (metadata >= 8) {
            worldIn.func_180501_a(pos, this.func_176203_a(8 + change), 3);
        } else if (metadata >= 4) {
            worldIn.func_180501_a(pos, this.func_176203_a(4 + change), 3);
        } else if (metadata >= 0) {
            worldIn.func_180501_a(pos, this.func_176203_a(0 + change), 3);
        }
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock(state, world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        int tier = metadata / 8 + 1;
        TileBaseUniversalElectrical tile = (metadata & 4) == 4 ? new TileEntityElectricFurnace(tier) : new TileEntityEnergyStorageModule(tier);
        tile.func_145834_a(world);
        return tile;
    }

    public ItemStack getEnergyStorageModule() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getEnergyStorageCluster() {
        return new ItemStack((Block)this, 1, 8);
    }

    public ItemStack getElectricFurnace() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getElectricArcFurnace() {
        return new ItemStack((Block)this, 1, 12);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getEnergyStorageModule());
        par3List.add(this.getElectricFurnace());
        par3List.add(this.getEnergyStorageCluster());
        par3List.add(this.getElectricArcFurnace());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176222_j(world, pos);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getShiftDescription(int meta) {
        int tier = meta >= 8 ? 2 : 1;
        switch (meta & 4) {
            case 4: {
                return GCCoreUtil.translate("tile.electric_furnace_tier" + tier + ".description");
            }
            case 0: {
                return GCCoreUtil.translate("tile.energy_storage_module_tier" + tier + ".description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumTieredMachineType type = EnumTieredMachineType.byMetadata((int)Math.floor((double)meta / 4.0));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumTieredMachineType)((Object)state.func_177229_b(TYPE))).getMeta() * 4;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, TYPE, FILL_VALUE, SIDES});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        state = IMachineSides.addPropertyForTile(state, tile, MACHINESIDES_RENDERTYPE, (PropertyEnum<IMachineSidesProperties.MachineSidesModel>)SIDES);
        if (!(tile instanceof TileEntityEnergyStorageModule)) {
            return state.func_177226_a((IProperty)FILL_VALUE, (Comparable)Integer.valueOf(0));
        }
        int energyLevel = ((TileEntityEnergyStorageModule)tile).scaledEnergyLevel;
        if (state.func_177229_b(TYPE) == EnumTieredMachineType.STORAGE_CLUSTER) {
            energyLevel += 17;
        }
        return state.func_177226_a((IProperty)FILL_VALUE, (Comparable)Integer.valueOf(energyLevel));
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    @Override
    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMachineSides) {
            ((IMachineSides)tile).nextSideConfiguration(tile);
            return true;
        }
        return false;
    }

    public static enum EnumTieredMachineType implements IStringSerializable
    {
        STORAGE_MODULE(0, "energy_storage"),
        ELECTRIC_FURNACE(1, "electric_furnace"),
        STORAGE_CLUSTER(2, "cluster_storage"),
        ARC_FURNACE(3, "arc_furnace");

        private final int meta;
        private final String name;
        private static final EnumTieredMachineType[] values;

        private EnumTieredMachineType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumTieredMachineType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumTieredMachineType.values();
        }
    }
}

