/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockMachine
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final int COAL_GENERATOR_METADATA = 0;
    public static final int COMPRESSOR_METADATA = 12;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachine(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                float particlePosX = (float)pos.func_177958_n() + 0.5f;
                float particlePosY = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float particlePosZ = (float)pos.func_177952_p() + 0.5f;
                float particleSize0 = 0.52f;
                float particleSize1 = rand.nextFloat() * 0.6f - 0.3f;
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a((metadata & 0xC) + change), 3);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a((metadata & 0xC) + change), 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = this.func_176201_c(state) & 0xC;
        if (metadata == 12) {
            return new TileEntityIngotCompressor();
        }
        if (metadata == 4) {
            return new TileEntityEnergyStorageModule();
        }
        if (metadata == 8) {
            return new TileEntityElectricFurnace();
        }
        return new TileEntityCoalGenerator();
    }

    public ItemStack getCompressor() {
        return new ItemStack((Block)this, 1, 12);
    }

    public ItemStack getCoalGenerator() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getCoalGenerator());
        par3List.add(this.getCompressor());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176222_j(world, pos);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 0: {
                return GCCoreUtil.translate("tile.coal_generator.description");
            }
            case 12: {
                return GCCoreUtil.translate("tile.compressor.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineType type = EnumMachineType.byMetadata((int)Math.floor((double)meta / 4.0));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMeta() * 4;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        COAL_GENERATOR(0, "coal_generator"),
        COMPRESSOR(3, "ingot_compressor");

        private final int meta;
        private final String name;

        private EnumMachineType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumMachineType byMetadata(int meta) {
            switch (meta) {
                case 3: {
                    return COMPRESSOR;
                }
            }
            return COAL_GENERATOR;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

