/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidTank
extends Block
implements IShiftDescription,
ISortableBlock,
ITileEntityProvider {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB((double)0.05f, 0.0, (double)0.05f, (double)0.95f, 1.0, (double)0.95f);

    public BlockFluidTank(String assetName) {
        super(Material.field_151592_s);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(field_149778_k);
        this.func_149663_c(assetName);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            tank.onBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{UP, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(stateAbove.func_177230_c() == this)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(stateBelow.func_177230_c() == this));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFluidTank();
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.func_149676_a((float)BlockFluidTank.BOUNDS.field_72340_a, (float)BlockFluidTank.BOUNDS.field_72338_b, (float)BlockFluidTank.BOUNDS.field_72339_c, (float)BlockFluidTank.BOUNDS.field_72336_d, (float)BlockFluidTank.BOUNDS.field_72337_e, (float)BlockFluidTank.BOUNDS.field_72334_f);
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180640_a(worldIn, pos, state);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack current = playerIn.field_71071_by.func_70448_g();
        if (current != null && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            return FluidUtil.interactWithTank(current, playerIn, tank, side);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            return tank.fluidTank.getFluid() == null || tank.fluidTank.getFluid().amount == 0 ? 0 : tank.fluidTank.getFluid().getFluid().getLuminosity(tank.fluidTank.getFluid());
        }
        return 0;
    }
}

