/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidPipe
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    public Vector3 minVector = new Vector3(0.35, 0.35, 0.35);
    public Vector3 maxVector = new Vector3(0.65, 0.65, 0.65);
    public static boolean ignoreDrop = false;
    private EnumPipeMode mode;

    public BlockFluidPipe(String assetName, EnumPipeMode mode) {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(Block.field_149778_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
        this.func_149663_c(assetName);
        this.mode = mode;
    }

    @Override
    public Vector3 getMinVector(IBlockState state) {
        return this.minVector;
    }

    @Override
    public Vector3 getMaxVector(IBlockState state) {
        return this.maxVector;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityFluidPipe tile = (TileEntityFluidPipe)worldIn.func_175625_s(pos);
        int pipeColor = ((EnumDyeColor)state.func_177229_b(COLOR)).func_176767_b();
        if (!ignoreDrop && tile != null && pipeColor != 15) {
            this.spawnItem(worldIn, pos, pipeColor);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)GCBlocks.oxygenPipe);
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        worldIn.func_175679_n(pos);
    }

    public CreativeTabs func_149708_J() {
        if (this.mode == EnumPipeMode.NORMAL) {
            return GalacticraftCore.galacticraftBlocksTab;
        }
        return null;
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityFluidPipe tile = (TileEntityFluidPipe)world.func_175625_s(pos);
            tile.switchType();
        }
        return true;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        TileEntityFluidPipe tileEntity = (TileEntityFluidPipe)worldIn.func_175625_s(pos);
        if (super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!worldIn.field_72995_K && (stack = playerIn.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemDye) {
            int dyeColor = playerIn.field_71071_by.func_70448_g().func_77952_i();
            byte colorBefore = tileEntity.getColor(state);
            tileEntity.onColorUpdate();
            worldIn.func_175656_a(pos, state.func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176766_a((int)dyeColor)));
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_RECOLOR_PIPE, GCCoreUtil.getDimensionID(worldIn), new Object[]{pos}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(worldIn), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 40.0));
            if (colorBefore != (byte)dyeColor && !playerIn.field_71075_bZ.field_75098_d && --playerIn.field_71071_by.func_70448_g().field_77994_a == 0) {
                playerIn.field_71071_by.field_70462_a[playerIn.field_71071_by.field_70461_c] = null;
            }
            if (colorBefore != (byte)dyeColor && colorBefore != 15) {
                this.spawnItem(worldIn, pos, colorBefore);
            }
            BlockPos tileVec = tileEntity.func_174877_v();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileEntity tileAt = worldIn.func_175625_s(tileVec.func_177972_a(dir));
                if (tileAt == null || !(tileAt instanceof IColorable)) continue;
                ((IColorable)tileAt).onAdjacentColorChanged(dir);
            }
            return true;
        }
        return false;
    }

    private void spawnItem(World worldIn, BlockPos pos, int colorBefore) {
        float f = 0.7f;
        Random syncRandom = GCCoreUtil.getRandom(pos);
        double d0 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(syncRandom.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
        double d2 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(Items.field_151100_aR, 1, colorBefore));
        entityitem.func_174869_p();
        worldIn.func_72838_d((Entity)entityitem);
    }

    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFluidPipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return this.func_180640_a(worldIn, pos, worldIn.func_180495_p(pos));
    }

    @Override
    public NetworkType getNetworkType(IBlockState state) {
        return NetworkType.FLUID;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{COLOR, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TRANSMITTER;
    }

    public EnumPipeMode getMode() {
        return this.mode;
    }

    public static enum EnumPipeMode implements IStringSerializable
    {
        NORMAL(0, "normal"),
        PULL(1, "pull");

        private final int meta;
        private final String name;

        private EnumPipeMode(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumPipeMode byMetadata(int ordinal) {
            return EnumPipeMode.values()[ordinal];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

