/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFallenMeteor;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFallenMeteor
extends Block
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public BlockFallenMeteor(String assetName) {
        super(Material.field_151576_e);
        this.func_149676_a(0.175f, 0.0f, 0.175f, 0.825f, 0.75f, 0.825f);
        this.func_149711_c(40.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149679_a(int par1, Random par2Random) {
        return 1 + (int)(par2Random.nextFloat() + 0.75f);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return GCItems.meteoricIronRaw;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFallenMeteor) {
            TileEntityFallenMeteor meteor = (TileEntityFallenMeteor)tile;
            if (meteor.getHeatLevel() <= 0) {
                return;
            }
            if (entityIn instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entityIn;
                worldIn.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), "random.fizz", 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int var5 = 0; var5 < 8; ++var5) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 0.2 + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
                if (!livingEntity.func_70027_ad()) {
                    livingEntity.func_70015_d(2);
                }
                double var9 = (double)((float)pos.func_177958_n() + 0.5f) - livingEntity.field_70165_t;
                double var7 = livingEntity.field_70161_v - (double)pos.func_177952_p();
                while (var9 * var9 + var7 * var7 < 1.0E-4) {
                    var9 = (Math.random() - Math.random()) * 0.01;
                    var7 = (Math.random() - Math.random()) * 0.01;
                }
                livingEntity.func_70653_a((Entity)livingEntity, 1.0f, var9, var7);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_180501_a(pos, this.func_176223_P(), 3);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFallenMeteor) {
            ((TileEntityFallenMeteor)tile).setHeatLevel(0);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.tryToFall(worldIn, pos, state);
        }
    }

    private void tryToFall(World world, BlockPos pos, IBlockState state) {
        if (this.canFallBelow(world, pos.func_177977_b()) && pos.func_177956_o() >= 0) {
            int prevHeatLevel = ((TileEntityFallenMeteor)world.func_175625_s(pos)).getHeatLevel();
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            BlockPos blockpos1 = pos.func_177977_b();
            while (this.canFallBelow(world, blockpos1) && blockpos1.func_177956_o() > 0) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (blockpos1.func_177956_o() >= 0) {
                world.func_180501_a(blockpos1.func_177984_a(), state, 3);
                ((TileEntityFallenMeteor)world.func_175625_s(blockpos1.func_177984_a())).setHeatLevel(prevHeatLevel);
            }
        }
    }

    private boolean canFallBelow(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        return block.func_149688_o() == Material.field_151586_h ? true : block.func_149688_o() == Material.field_151587_i;
    }

    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFallenMeteor) {
            TileEntityFallenMeteor meteor = (TileEntityFallenMeteor)tile;
            Vector3 col = new Vector3(198.0, 108.0, 58.0);
            col.translate(200.0f - meteor.getScaledHeatLevel() * 200.0f);
            col.x = Math.min(255.0, col.x);
            col.y = Math.min(255.0, col.y);
            col.z = Math.min(255.0, col.z);
            return ColorUtil.to32BitColor(255, (byte)col.x, (byte)col.y, (byte)col.z);
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFallenMeteor();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public float func_180647_a(EntityPlayer player, World world, BlockPos pos) {
        float hardness = this.func_176195_g(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        IBlockState state = world.func_180495_p(pos);
        int power = this.canHarvestBlock(this, player, state);
        if (power > 0) {
            return (float)power * player.getBreakSpeed(state, pos) / hardness / 30.0f;
        }
        return player.getBreakSpeed(state, pos) / hardness / 30.0f;
    }

    public int canHarvestBlock(Block block, EntityPlayer player, IBlockState state) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.func_146099_a(block) ? 1 : 0;
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool) - block.getHarvestLevel(state) + 1;
        if (toolLevel < 1) {
            return player.func_146099_a(block) ? 1 : 0;
        }
        return toolLevel;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public int getExpDrop(IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)3, (int)7);
    }
}

