/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBrightLamp
extends BlockAdvanced
implements IShiftDescription,
ITileEntityProvider,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockBrightLamp(String assetName) {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
        this.func_149715_a(0.9f);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this) {
            return block.getLightValue(world, pos);
        }
        if (world instanceof World) {
            return RedstoneUtil.isBlockReceivingRedstone((World)world, pos) ? 0 : this.func_149750_m();
        }
        return 0;
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return 1;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        double boundsMin = 0.2;
        double boundsMax = 0.8;
        return AxisAlignedBB.func_178781_a((double)((double)pos.func_177958_n() + boundsMin), (double)((double)pos.func_177956_o() + boundsMin), (double)((double)pos.func_177952_p() + boundsMin), (double)((double)pos.func_177958_n() + boundsMax), (double)((double)pos.func_177956_o() + boundsMax), (double)((double)pos.func_177952_p() + boundsMax));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState state = worldIn.func_180495_p(offsetPos);
            if (!state.func_177230_c().isSideSolid((IBlockAccess)worldIn, offsetPos, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)))) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing opposite = facing.func_176734_d();
        BlockPos offsetPos = pos.func_177972_a(opposite);
        IBlockState state = worldIn.func_180495_p(offsetPos);
        if (state.func_177230_c().isSideSolid((IBlockAccess)worldIn, offsetPos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)opposite);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos offsetPos = pos.func_177972_a(side);
        IBlockState state1 = worldIn.func_180495_p(offsetPos);
        if (state1.func_177230_c().isSideSolid((IBlockAccess)worldIn, offsetPos, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)))) {
            return;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        EnumFacing side = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        float var8 = 0.3f;
        if (side == EnumFacing.WEST) {
            this.func_149676_a(0.0f, 0.2f, 0.5f - var8, var8 * 2.0f, 0.8f, 0.5f + var8);
        } else if (side == EnumFacing.EAST) {
            this.func_149676_a(1.0f - var8 * 2.0f, 0.2f, 0.5f - var8, 1.0f, 0.8f, 0.5f + var8);
        } else if (side == EnumFacing.NORTH) {
            this.func_149676_a(0.5f - var8, 0.2f, 0.0f, 0.5f + var8, 0.8f, var8 * 2.0f);
        } else if (side == EnumFacing.SOUTH) {
            this.func_149676_a(0.5f - var8, 0.2f, 1.0f - var8 * 2.0f, 0.5f + var8, 0.8f, 1.0f);
        } else if (side == EnumFacing.DOWN) {
            this.func_149676_a(0.5f - var8, 0.0f, 0.5f - var8, 0.5f + var8, 0.6f, 0.5f + var8);
        } else {
            this.func_149676_a(0.5f - var8, 0.4f, 0.5f - var8, 0.5f + var8, 1.0f, 0.5f + var8);
        }
        return super.func_180636_a(worldIn, pos, start, end);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityArclamp) {
            ((TileEntityArclamp)tile).facingChanged();
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityArclamp();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

