/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalConductor;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWireSwitch;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAluminumWire
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumWireType> WIRE_TYPE = PropertyEnum.func_177709_a((String)"wireType", EnumWireType.class);
    private Vector3 minVectorNormal = new Vector3(0.38, 0.38, 0.38);
    private Vector3 minVectorHeavy = new Vector3(0.3, 0.3, 0.3);
    private Vector3 maxVectorNormal = new Vector3(0.62, 0.62, 0.62);
    private Vector3 maxVectorHeavy = new Vector3(0.7, 0.7, 0.7);

    public BlockAluminumWire(String assetName) {
        super(Material.field_151580_n);
        this.func_149672_a(Block.field_149775_l);
        this.func_149752_b(0.2f);
        this.func_149676_a(0.4f, 0.4f, 0.4f, 0.6f, 0.6f, 0.6f);
        this.func_149711_c(0.075f);
        this.func_149663_c(assetName);
    }

    @Override
    public Vector3 getMinVector(IBlockState state) {
        EnumWireType type = (EnumWireType)((Object)state.func_177229_b(WIRE_TYPE));
        if (type == EnumWireType.ALUMINUM_WIRE || type == EnumWireType.ALUMINUM_WIRE_SWITCHED) {
            return this.minVectorNormal;
        }
        return this.minVectorHeavy;
    }

    @Override
    public Vector3 getMaxVector(IBlockState state) {
        EnumWireType type = (EnumWireType)((Object)state.func_177229_b(WIRE_TYPE));
        if (type == EnumWireType.ALUMINUM_WIRE || type == EnumWireType.ALUMINUM_WIRE_SWITCHED) {
            return this.maxVectorNormal;
        }
        return this.maxVectorHeavy;
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TileBaseUniversalConductor tile;
        switch (metadata) {
            case 0: {
                tile = new TileEntityAluminumWire(1);
                break;
            }
            case 1: {
                tile = new TileEntityAluminumWire(2);
                break;
            }
            case 2: {
                tile = new TileEntityAluminumWireSwitch(1);
                break;
            }
            case 3: {
                tile = new TileEntityAluminumWireSwitch(2);
                break;
            }
            default: {
                return null;
            }
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    @Override
    public NetworkType getNetworkType(IBlockState state) {
        return NetworkType.POWER;
    }

    @Override
    public String getShiftDescription(int itemDamage) {
        switch (itemDamage) {
            case 0: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire.description");
            }
            case 1: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_heavy.description");
            }
            case 2: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_switch.description");
            }
            case 3: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_switch_heavy.description");
            }
        }
        return "";
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WIRE_TYPE, (Comparable)((Object)EnumWireType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWireType)((Object)state.func_177229_b(WIRE_TYPE))).getMeta();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{WIRE_TYPE, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public boolean showDescription(int itemDamage) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TRANSMITTER;
    }

    public static enum EnumWireType implements IStringSerializable
    {
        ALUMINUM_WIRE(0, "alu_wire"),
        ALUMINUM_WIRE_HEAVY(1, "alu_wire_heavy"),
        ALUMINUM_WIRE_SWITCHED(2, "alu_wire_switch"),
        ALUMINUM_WIRE_SWITCHED_HEAVY(3, "alu_wire_switch_heavy");

        private final int meta;
        private final String name;
        private static final EnumWireType[] values;

        private EnumWireType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumWireType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumWireType.values();
        }
    }
}

