/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAirLockWall
extends BlockBreakable
implements IPartialSealableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumAirLockSealConnection> CONNECTION_TYPE = PropertyEnum.func_177709_a((String)"connection", EnumAirLockSealConnection.class);

    public BlockAirLockWall(String assetName) {
        super(Material.field_151573_f, false);
        this.func_149675_a(true);
        this.func_149711_c(1000.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180640_a(worldIn, pos, state);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        switch (this.getConnection(worldIn, pos)) {
            case FLAT: {
                this.func_149676_a(0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 1.0f);
                break;
            }
            case X: {
                this.func_149676_a(0.25f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                break;
            }
            case Z: {
                this.func_149676_a(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 0.75f);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        return true;
    }

    public Item func_180665_b(World world, BlockPos pos) {
        return null;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{CONNECTION_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECTION_TYPE, (Comparable)((Object)this.getConnection(worldIn, pos)));
    }

    private EnumAirLockSealConnection getConnection(IBlockAccess worldIn, BlockPos pos) {
        EnumAirLockSealConnection connection;
        Block frameID = GCBlocks.airLockFrame;
        Block sealID = GCBlocks.airLockSeal;
        Block idXMin = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c();
        Block idXMax = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c();
        if (idXMin != frameID && idXMax != frameID && idXMin != sealID && idXMax != sealID) {
            connection = EnumAirLockSealConnection.X;
        } else {
            int adjacentCount = 0;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                Block blockID = worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c();
                if (blockID != GCBlocks.airLockFrame && blockID != GCBlocks.airLockSeal) continue;
                ++adjacentCount;
            }
            connection = adjacentCount == 4 ? EnumAirLockSealConnection.FLAT : EnumAirLockSealConnection.Z;
        }
        return connection;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public static enum EnumAirLockSealConnection implements IStringSerializable
    {
        X("x"),
        Z("z"),
        FLAT("flat");

        private final String name;

        private EnumAirLockSealConnection(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

