/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GalacticraftRegistry {
    private static Map<Class<? extends WorldProvider>, ITeleportType> teleportTypeMap = new HashMap<Class<? extends WorldProvider>, ITeleportType>();
    private static List<SpaceStationType> spaceStations = new ArrayList<SpaceStationType>();
    private static List<INasaWorkbenchRecipe> rocketBenchT1Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> buggyBenchRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> rocketBenchT2Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> cargoRocketRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> rocketBenchT3Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> astroMinerRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static Map<Class<? extends WorldProvider>, ResourceLocation> rocketGuiMap = new HashMap<Class<? extends WorldProvider>, ResourceLocation>();
    private static Map<Integer, List<ItemStack>> dungeonLootMap = new HashMap<Integer, List<ItemStack>>();
    private static List<Integer> worldProviderIDs = new ArrayList<Integer>();
    private static List<IGameScreen> gameScreens = new ArrayList<IGameScreen>();
    private static int maxScreenTypes;
    private static Map<Integer, List<Object>> gearMap;
    private static Map<Integer, List<EnumExtendedInventorySlot>> gearSlotMap;

    public static void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        if (!teleportTypeMap.containsKey(clazz)) {
            teleportTypeMap.put(clazz, type);
        }
    }

    public static void registerRocketGui(Class<? extends WorldProvider> clazz, ResourceLocation rocketGui) {
        if (!rocketGuiMap.containsKey(clazz)) {
            rocketGuiMap.put(clazz, rocketGui);
        }
    }

    public static void addDungeonLoot(int tier, ItemStack loot) {
        List<Object> dungeonStacks = null;
        if (dungeonLootMap.containsKey(tier)) {
            dungeonStacks = dungeonLootMap.get(tier);
            dungeonStacks.add(loot);
        } else {
            dungeonStacks = new ArrayList<ItemStack>();
            dungeonStacks.add(loot);
        }
        dungeonLootMap.put(tier, dungeonStacks);
    }

    public static void addT1RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT1Recipes.add(recipe);
    }

    public static void addT2RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT2Recipes.add(recipe);
    }

    public static void addT3RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT3Recipes.add(recipe);
    }

    public static void addCargoRocketRecipe(INasaWorkbenchRecipe recipe) {
        cargoRocketRecipes.add(recipe);
    }

    public static void addMoonBuggyRecipe(INasaWorkbenchRecipe recipe) {
        buggyBenchRecipes.add(recipe);
    }

    public static void addAstroMinerRecipe(INasaWorkbenchRecipe recipe) {
        astroMinerRecipes.add(recipe);
    }

    public static void removeT1RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT1Recipes.remove(recipe);
    }

    public static void removeT2RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT2Recipes.remove(recipe);
    }

    public static void removeT3RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT3Recipes.remove(recipe);
    }

    public static void removeCargoRocketRecipe(INasaWorkbenchRecipe recipe) {
        cargoRocketRecipes.remove(recipe);
    }

    public static void removeMoonBuggyRecipe(INasaWorkbenchRecipe recipe) {
        buggyBenchRecipes.remove(recipe);
    }

    public static void removeAstroMinerRecipe(INasaWorkbenchRecipe recipe) {
        astroMinerRecipes.remove(recipe);
    }

    public static void removeAllT1RocketRecipes() {
        rocketBenchT1Recipes.clear();
    }

    public static void removeAllT2RocketRecipes() {
        rocketBenchT2Recipes.clear();
    }

    public static void removeAllT3RocketRecipes() {
        rocketBenchT3Recipes.clear();
    }

    public static void removeAllCargoRocketRecipes() {
        cargoRocketRecipes.clear();
    }

    public static void removeAllMoonBuggyRecipes() {
        buggyBenchRecipes.clear();
    }

    public static void removeAllAstroMinerRecipes() {
        astroMinerRecipes.clear();
    }

    public static ITeleportType getTeleportTypeForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return teleportTypeMap.get(clazz);
    }

    public static void registerSpaceStation(SpaceStationType type) {
        for (SpaceStationType type1 : spaceStations) {
            if (type1.getWorldToOrbitID() != type.getWorldToOrbitID()) continue;
            throw new RuntimeException("Two space station types registered with the same home planet ID: " + type.getWorldToOrbitID());
        }
        spaceStations.add(type);
    }

    public static void replaceSpaceStationRecipe(int spaceStationID, HashMap<Object, Integer> obj) {
        for (SpaceStationType type1 : spaceStations) {
            if (type1.getSpaceStationID() != spaceStationID) continue;
            type1.setRecipeForSpaceStation(new SpaceStationRecipe(obj));
        }
    }

    public SpaceStationType getTypeFromPlanetID(int planetID) {
        return spaceStations.get(planetID);
    }

    public static List<SpaceStationType> getSpaceStationData() {
        return spaceStations;
    }

    public static List<INasaWorkbenchRecipe> getRocketT1Recipes() {
        return rocketBenchT1Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT2Recipes() {
        return rocketBenchT2Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT3Recipes() {
        return rocketBenchT3Recipes;
    }

    public static List<INasaWorkbenchRecipe> getCargoRocketRecipes() {
        return cargoRocketRecipes;
    }

    public static List<INasaWorkbenchRecipe> getBuggyBenchRecipes() {
        return buggyBenchRecipes;
    }

    public static List<INasaWorkbenchRecipe> getAstroMinerRecipes() {
        return astroMinerRecipes;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getResouceLocationForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return rocketGuiMap.get(clazz);
    }

    public static List<ItemStack> getDungeonLoot(int tier) {
        return dungeonLootMap.get(tier);
    }

    public static boolean registerProvider(int id, Class<? extends WorldProvider> provider, boolean keepLoaded, int defaultID) {
        boolean flag = DimensionManager.registerProviderType((int)id, provider, (boolean)keepLoaded);
        if (flag) {
            worldProviderIDs.add(id);
            return true;
        }
        worldProviderIDs.add(defaultID);
        FMLLog.severe((String)("Could not register dimension " + id + " - does it clash with another mod?  Change the ID in config."), (Object[])new Object[0]);
        return false;
    }

    @Deprecated
    public static void registerProvider(int id, Class<? extends WorldProvider> provider, boolean keepLoaded) {
        GalacticraftRegistry.registerProvider(id, provider, keepLoaded, 0);
    }

    public static int getProviderID(int index) {
        return worldProviderIDs.get(index);
    }

    public static int registerScreen(IGameScreen screen) {
        gameScreens.add(screen);
        screen.setFrameSize(0.098f);
        return ++maxScreenTypes - 1;
    }

    public static void registerScreensServer(int maxTypes) {
        maxScreenTypes = maxTypes;
    }

    public static int getMaxScreenTypes() {
        return maxScreenTypes;
    }

    public static IGameScreen getGameScreen(int type) {
        return gameScreens.get(type);
    }

    public static void registerGear(int gearID, EnumExtendedInventorySlot type, Item item) {
        GalacticraftRegistry.addGearObject(gearID, type, item);
    }

    public static void registerGear(int gearID, EnumExtendedInventorySlot type, ItemStack itemStack) {
        GalacticraftRegistry.addGearObject(gearID, type, itemStack);
    }

    private static void addGearObject(int gearID, EnumExtendedInventorySlot type, Object obj) {
        if (gearMap.containsKey(gearID)) {
            if (!gearMap.get(gearID).contains(obj)) {
                gearMap.get(gearID).add(obj);
            }
        } else {
            ArrayList gear = Lists.newArrayList();
            gear.add(obj);
            gearMap.put(gearID, gear);
        }
        if (gearSlotMap.containsKey(gearID)) {
            if (!gearSlotMap.get(gearID).contains((Object)type)) {
                gearSlotMap.get(gearID).add(type);
            }
        } else {
            ArrayList gearType = Lists.newArrayList();
            gearType.add(type);
            gearSlotMap.put(gearID, gearType);
        }
    }

    public static List<ItemStack> listAllGearForSlot(EnumExtendedInventorySlot slotType) {
        LinkedList<ItemStack> result = new LinkedList<ItemStack>();
        for (Map.Entry<Integer, List<Object>> entry : gearMap.entrySet()) {
            List<EnumExtendedInventorySlot> slotType1 = GalacticraftRegistry.getSlotType(entry.getKey());
            if (!slotType1.contains((Object)slotType)) continue;
            List<Object> objectList = entry.getValue();
            for (Object o : objectList) {
                if (o instanceof ItemStack) {
                    result.add((ItemStack)o);
                    continue;
                }
                if (!(o instanceof Item)) continue;
                result.add(new ItemStack((Item)o));
            }
        }
        return result;
    }

    public static int findMatchingGearID(ItemStack stack, EnumExtendedInventorySlot slotType) {
        for (Map.Entry<Integer, List<Object>> entry : gearMap.entrySet()) {
            List<EnumExtendedInventorySlot> slotType1 = GalacticraftRegistry.getSlotType(entry.getKey());
            List<Object> objectList = entry.getValue();
            if (!slotType1.contains((Object)slotType)) continue;
            for (Object o : objectList) {
                if (!(o instanceof Item ? stack.func_77973_b() == o : o instanceof ItemStack && stack.func_77973_b() == ((ItemStack)o).func_77973_b() && stack.func_77952_i() == ((ItemStack)o).func_77952_i())) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    public static List<EnumExtendedInventorySlot> getSlotType(int gearID) {
        return gearSlotMap.get(gearID);
    }

    static {
        gearMap = new HashMap<Integer, List<Object>>();
        gearSlotMap = new HashMap<Integer, List<EnumExtendedInventorySlot>>();
    }
}

