/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.BiomeGenBaseVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.layer.GenLayerVenus;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldChunkManagerVenus
extends WorldChunkManager {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> biomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerVenus() {
    }

    public WorldChunkManagerVenus(long seed, WorldType type) {
        this();
        GenLayer[] genLayers = GenLayerVenus.createWorld(seed);
        this.unzoomedBiomes = genLayers[0];
        this.zoomedBiomes = genLayers[1];
    }

    public WorldChunkManagerVenus(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public List<BiomeGenBase> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_180300_a(BlockPos pos, BiomeGenBase biomeGenBaseIn) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), BiomeGenBaseVenus.venusFlat);
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        Arrays.fill(par1ArrayOfFloat, 0, par4 * par5, 0.0f);
        return par1ArrayOfFloat;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int x, int z, int length, int width) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < length * width) {
            biomes = new BiomeGenBase[length * width];
        }
        int[] intArray = this.unzoomedBiomes.func_75904_a(x, z, length, width);
        for (int i = 0; i < length * width; ++i) {
            biomes[i] = intArray[i] >= 0 ? BiomeGenBase.func_150568_d((int)intArray[i]) : BiomeGenBaseVenus.venusFlat;
        }
        return biomes;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] oldBiomeList, int x, int z, int length, int width) {
        return this.func_76931_a(oldBiomeList, x, z, length, width, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] listToReuse, int x, int z, int length, int width, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < length * width) {
            listToReuse = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] cached = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cached, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] zoomed = this.zoomedBiomes.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = zoomed[i] >= 0 ? BiomeGenBase.func_150568_d((int)zoomed[i]) : BiomeGenBaseVenus.venusFlat;
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int range, List<BiomeGenBase> viables) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int diffX = k - i + 1;
        int diffZ = l - j + 1;
        int[] unzoomed = this.unzoomedBiomes.func_75904_a(i, j, diffX, diffZ);
        for (int a = 0; a < diffX * diffZ; ++a) {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)unzoomed[a]);
            if (viables.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<BiomeGenBase> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int diffX = k - i + 1;
        int diffZ = l - j + 1;
        int[] unzoomed = this.unzoomedBiomes.func_75904_a(i, j, diffX, diffZ);
        BlockPos blockPos = null;
        int count = 0;
        for (int a = 0; a < unzoomed.length; ++a) {
            int x0 = i + a % diffX << 2;
            int z0 = j + a / diffX << 2;
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)unzoomed[a]);
            if (!biomes.contains(biome) || blockPos != null && random.nextInt(count + 1) != 0) continue;
            blockPos = new BlockPos(x0, 0, z0);
            ++count;
        }
        return blockPos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

