/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client.render.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.planets.venus.client.model.ModelSpiderQueen;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderSpiderQueen
extends RenderLiving<EntitySpiderQueen> {
    private static final ResourceLocation spiderTexture = new ResourceLocation("galacticraftplanets", "textures/model/spider_queen.png");
    public static IFlexibleBakedModel webModel;

    public RenderSpiderQueen(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelSpiderQueen(), 0.5f);
    }

    private void updateModels() {
        if (webModel == null) {
            try {
                webModel = ClientUtil.modelFromOBJ((ResourceLocation)new ResourceLocation("galacticraftplanets", "web.obj"), (List)ImmutableList.of((Object)"Sphere"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void preRenderCallback(EntitySpiderQueen entity, float partialTickTime) {
        if (entity.getBurrowedCount() >= 0) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)entity.field_70131_O, (float)0.0f);
        }
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glRotatef((float)((float)(Math.pow(entity.deathTicks, 2.0) / 5.0 + (Math.pow(entity.deathTicks, 2.0) / 5.0 - Math.pow(entity.deathTicks - 1, 2.0) / 5.0) * (double)partialTickTime)), (float)0.0f, (float)1.0f, (float)0.0f);
        super.func_77041_b((EntityLivingBase)entity, partialTickTime);
    }

    public void doRender(EntitySpiderQueen entity, double x, double y, double z, float entityYaw, float partialTicks) {
        BossStatus.func_82824_a((IBossDisplayData)entity, (boolean)false);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.8f), (float)((float)z));
        GL11.glScalef((float)1.4f, (float)1.5f, (float)1.4f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.updateModels();
        RenderHelper.func_74518_a();
        this.func_110776_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        if (entity.getBurrowedCount() >= 0) {
            GL11.glDisable((int)2884);
            ClientUtil.drawBakedModel((IFlexibleBakedModel)webModel);
            GL11.glScalef((float)1.05f, (float)1.1f, (float)1.05f);
            GL11.glRotatef((float)192.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            ClientUtil.drawBakedModel((IFlexibleBakedModel)webModel);
            GL11.glEnable((int)2884);
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(EntitySpiderQueen juicer) {
        return spiderTexture;
    }
}

