/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.venus.ConfigManagerVenus;
import micdoodle8.mods.galacticraft.planets.venus.client.FakeLightningBoltRenderer;
import micdoodle8.mods.galacticraft.planets.venus.client.SkyProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.client.WeatherRendererVenus;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TickHandlerClientVenus {
    private Map<BlockPos, Integer> lightning = Maps.newHashMap();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        if (event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void renderLightning(ClientProxyCore.EventSpecialRender event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player != null && !ConfigManagerVenus.disableAmbientLightning) {
            for (Map.Entry<BlockPos, Integer> entry : this.lightning.entrySet()) {
                long seed = entry.getValue() / 10 + entry.getKey().func_177958_n() + entry.getKey().func_177952_p();
                FakeLightningBoltRenderer.renderBolt(seed, (double)entry.getKey().func_177958_n() - ClientProxyCore.playerPosX, (double)entry.getKey().func_177956_o() - ClientProxyCore.playerPosY, (double)entry.getKey().func_177952_p() - ClientProxyCore.playerPosZ);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        WorldClient world = minecraft.field_71441_e;
        if (world != null && world.field_73011_w instanceof WorldProviderVenus) {
            if (world.field_73011_w.getSkyRenderer() == null) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderVenus((IGalacticraftWorldProvider)world.field_73011_w));
            }
            if (world.field_73011_w.getCloudRenderer() == null) {
                world.field_73011_w.setCloudRenderer((IRenderHandler)new CloudRenderer());
            }
            if (world.field_73011_w.getWeatherRenderer() == null) {
                world.field_73011_w.setWeatherRenderer((IRenderHandler)new WeatherRendererVenus());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == event.player && !ConfigManagerVenus.disableAmbientLightning) {
            Iterator<Map.Entry<BlockPos, Integer>> it = this.lightning.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = it.next();
                int val = entry.getValue();
                if (val - 1 <= 0) {
                    it.remove();
                    continue;
                }
                entry.setValue(val - 1);
            }
            if (player.func_70681_au().nextInt(300 + (int)(800.0f * minecraft.field_71441_e.field_73004_o)) == 0 && minecraft.field_71441_e.field_73011_w instanceof WorldProviderVenus) {
                double freq = player.func_70681_au().nextDouble() * Math.PI * 2.0;
                double dist = 180.0;
                double dX = dist * Math.cos(freq);
                double dZ = dist * Math.sin(freq);
                double posX = player.field_70165_t + dX;
                double posY = 70.0;
                double posZ = player.field_70161_v + dZ;
                minecraft.field_71441_e.func_72980_b(posX, posY, posZ, "ambient.weather.thunder", 500.0f + player.func_70681_au().nextFloat() * 500.0f, 1.0f + player.func_70681_au().nextFloat() * 0.2f, false);
                this.lightning.put(new BlockPos(posX, posY, posZ), 20);
            }
        }
    }
}

