/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchWeb
extends Block
implements IShearable,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumWebType> WEB_TYPE = PropertyEnum.func_177709_a((String)"webType", EnumWebType.class);

    public BlockTorchWeb(String assetName) {
        super(Material.field_151594_q);
        this.func_149715_a(1.0f);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        EnumWebType type = (EnumWebType)((Object)worldIn.func_180495_p(pos).func_177229_b(WEB_TYPE));
        float f = 0.15f;
        if (type == EnumWebType.WEB_0) {
            this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        } else if (type == EnumWebType.WEB_1) {
            this.func_149676_a(0.5f - f, 0.25f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        }
        return super.func_180636_a(worldIn, pos, start, end);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177229_b(WEB_TYPE) == EnumWebType.WEB_1) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState blockUp = world.func_180495_p(pos.func_177984_a());
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return blockUp.func_177230_c().func_149688_o().func_76220_a() || blockUp.func_177230_c() == this && blockUp.func_177229_b(WEB_TYPE) == EnumWebType.WEB_0;
        }
        return blockUp.func_177230_c() == this && blockUp.func_177229_b(WEB_TYPE) == EnumWebType.WEB_0;
    }

    public boolean func_176193_a(World world, BlockPos pos, EnumFacing side, ItemStack itemStack) {
        if (world == null || pos == null || side == null || itemStack == null) {
            return false;
        }
        return this.canBlockStay(world, pos, this.func_176203_a(itemStack.func_77960_j()));
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.checkAndDropBlock(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos))));
        return ret;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WEB_TYPE, (Comparable)((Object)EnumWebType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWebType)((Object)state.func_177229_b(WEB_TYPE))).getMeta();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{WEB_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumWebType implements IStringSerializable
    {
        WEB_0(0, "web_torch_0"),
        WEB_1(1, "web_torch_1");

        private final int meta;
        private final String name;
        private static final EnumWebType[] values;

        private EnumWebType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumWebType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumWebType.values();
        }
    }
}

