/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityCrashedProbe;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrashedProbe
extends BlockTileGC
implements ISortableBlock,
ITileEntityProvider {
    public static final String CRASHED_PROBE = "crashedProbe";
    private static final List<WeightedRandomChestContent> CONTENTS = Lists.newArrayList((Object[])new WeightedRandomChestContent[]{new WeightedRandomChestContent(MarsItems.marsItemBasic, 3, 3, 6, 5), new WeightedRandomChestContent(GCItems.heavyPlatingTier1, 0, 3, 6, 5), new WeightedRandomChestContent(AsteroidsItems.basicItem, 6, 3, 6, 5), new WeightedRandomChestContent(Items.field_151042_j, 0, 5, 9, 5), new WeightedRandomChestContent(AsteroidsItems.basicItem, 5, 3, 6, 5)});

    public BlockCrashedProbe(String assetName) {
        super(Material.field_151573_f);
        this.field_149782_v = 4.5f;
        this.field_149781_w = 2.5f;
        this.func_149672_a(field_149777_j);
        this.func_149675_a(true);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrashedProbe();
    }

    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.65, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.9, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)GalacticraftPlanets.instance, 6, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrashedProbe && ((TileEntityCrashedProbe)tile).getDropCore()) {
            this.spawnItem(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void spawnItem(World worldIn, BlockPos pos) {
        float f = 0.7f;
        Random syncRandom = GCCoreUtil.getRandom((BlockPos)pos);
        double d0 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(syncRandom.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
        double d2 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(VenusItems.basicItem, 1, 2));
        entityitem.func_174869_p();
        worldIn.func_72838_d((Entity)entityitem);
    }

    static {
        ChestGenHooks.init((String)CRASHED_PROBE, CONTENTS, (int)4, (int)6);
    }
}

