/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus;

import java.util.List;
import micdoodle8.mods.galacticraft.api.client.IItemMeshDefinitionCustom;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.client.TickHandlerClientVenus;
import micdoodle8.mods.galacticraft.planets.venus.client.fx.EntityAcidExhaustFX;
import micdoodle8.mods.galacticraft.planets.venus.client.fx.EntityAcidVaporFX;
import micdoodle8.mods.galacticraft.planets.venus.client.gui.GuiCrashedProbe;
import micdoodle8.mods.galacticraft.planets.venus.client.gui.GuiGeothermal;
import micdoodle8.mods.galacticraft.planets.venus.client.gui.GuiSolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.client.render.entity.RenderEntryPodVenus;
import micdoodle8.mods.galacticraft.planets.venus.client.render.entity.RenderJuicer;
import micdoodle8.mods.galacticraft.planets.venus.client.render.entity.RenderSpiderQueen;
import micdoodle8.mods.galacticraft.planets.venus.client.render.entity.RenderWebShot;
import micdoodle8.mods.galacticraft.planets.venus.client.render.tile.TileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityEntryPodVenus;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityWebShot;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityCrashedProbe;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityGeothermalGenerator;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityTreasureChestVenus;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VenusModuleClient
implements IPlanetsModuleClient {
    private static ModelResourceLocation sulphuricAcidLocation = new ModelResourceLocation("galacticraftplanets:sulphuric_acid", "fluid");

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.addPlanetVariants("venus", "venus_rock_0", "venus_rock_1", "venus_rock_2", "venus_rock_3", "dungeon_brick_venus_1", "dungeon_brick_venus_2", "venus_ore_aluminum", "venus_ore_copper", "venus_ore_galena", "venus_ore_quartz", "venus_ore_silicon", "venus_ore_tin", "lead_block", "venus_ore_solar");
        this.addPlanetVariants("thermal_padding_t2", "thermal_helm_t2", "thermal_chestplate_t2", "thermal_leggings_t2", "thermal_boots_t2");
        this.addPlanetVariants("basic_item_venus", "shield_controller", "ingot_lead", "radioisotope_core", "thermal_fabric", "solar_dust", "solar_module_2", "thin_solar_wafer");
        this.addPlanetVariants("web_torch", "web_torch_0", "web_torch_1");
        MinecraftForge.EVENT_BUS.register((Object)this);
        RenderingRegistry.registerEntityRenderingHandler(EntityJuicer.class, manager -> new RenderJuicer(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityEntryPodVenus.class, manager -> new RenderEntryPodVenus(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiderQueen.class, manager -> new RenderSpiderQueen(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityWebShot.class, manager -> new RenderWebShot(manager));
    }

    private void addPlanetVariants(String name, String ... variants) {
        Item itemBlockVariants = GameRegistry.findItem((String)"GalacticraftPlanets", (String)name);
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation("galacticraftplanets:" + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    @Override
    public void registerVariants() {
        Item sludge = Item.func_150898_a((Block)VenusBlocks.sulphuricAcid);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galacticraftplanets:sulphuric_acid")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> sulphuricAcidLocation));
        ModelLoader.setCustomStateMapper((Block)VenusBlocks.sulphuricAcid, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return sulphuricAcidLocation;
            }
        });
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerClientVenus());
        VenusModuleClient.registerBlockRenderers();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(event, "pod_flame");
        this.registerTexture(event, "web");
    }

    private void registerTexture(TextureStitchEvent.Pre event, String texture) {
        event.map.func_174942_a(new ResourceLocation("galacticraftplanets:blocks/" + texture));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBakeEvent(ModelBakeEvent event) {
    }

    private void replaceModelDefault(ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtil.replaceModel((String)"galacticraftplanets", (ModelBakeEvent)event, (String)resLoc, (String)objLoc, visibleGroups, clazz, (IModelState)parentState, (String[])variants);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestVenus.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer());
    }

    public static void registerBlockRenderers() {
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)0, (String)"venus_rock_0");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)1, (String)"venus_rock_1");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)2, (String)"venus_rock_2");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)3, (String)"venus_rock_3");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)4, (String)"dungeon_brick_venus_1");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)5, (String)"dungeon_brick_venus_2");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)6, (String)"venus_ore_aluminum");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)7, (String)"venus_ore_copper");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)8, (String)"venus_ore_galena");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)9, (String)"venus_ore_quartz");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)10, (String)"venus_ore_silicon");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)11, (String)"venus_ore_tin");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)12, (String)"lead_block");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.venusBlock, (int)13, (String)"venus_ore_solar");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.spout, (int)0, (String)"spout");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.treasureChestTier3, (int)0, (String)"treasure_t3");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.torchWeb, (int)0, (String)"web_torch_0");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.torchWeb, (int)1, (String)"web_torch_1");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.geothermalGenerator, (int)0, (String)"geothermal_generator");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.crashedProbe);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.scorchedRock);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.bossSpawner);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.solarArrayModule);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)VenusBlocks.solarArrayController, (int)0, (String)"solar_array_controller");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.thermalPaddingTier2, (int)0, (String)"thermal_helm_t2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.thermalPaddingTier2, (int)1, (String)"thermal_chestplate_t2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.thermalPaddingTier2, (int)2, (String)"thermal_leggings_t2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.thermalPaddingTier2, (int)3, (String)"thermal_boots_t2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)0, (String)"shield_controller");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)1, (String)"ingot_lead");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)2, (String)"radioisotope_core");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)3, (String)"thermal_fabric");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)4, (String)"solar_dust");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)5, (String)"solar_module_2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.basicItem, (int)6, (String)"thin_solar_wafer");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)VenusItems.key, (int)0, (String)"key_t3");
    }

    private void addVariants(String name, ResourceLocation ... variants) {
        Item itemBlockVariants = GameRegistry.findItem((String)"GalacticraftPlanets", (String)name);
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.CLIENT) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (ID == 6) {
                if (tile instanceof TileEntityGeothermalGenerator) {
                    return new GuiGeothermal(player.field_71071_by, (TileEntityGeothermalGenerator)tile);
                }
                if (tile instanceof TileEntityCrashedProbe) {
                    return new GuiCrashedProbe(player.field_71071_by, (TileEntityCrashedProbe)tile);
                }
                if (tile instanceof TileEntitySolarArrayController) {
                    return new GuiSolarArrayController(player.field_71071_by, (TileEntitySolarArrayController)tile);
                }
            }
        }
        return null;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.func_175606_aa() != null && mc.field_71452_i != null) {
            double dX = mc.func_175606_aa().field_70165_t - position.x;
            double dY = mc.func_175606_aa().field_70163_u - position.y;
            double dZ = mc.func_175606_aa().field_70161_v - position.z;
            EntityFX particle = null;
            double viewDistance = 64.0;
            if (particleID.equals("acidVapor")) {
                particle = new EntityAcidVaporFX((World)mc.field_71441_e, position.x, position.y, position.z, motion.x, motion.y, motion.z, 2.5f);
            }
            if (dX * dX + dY * dY + dZ * dZ < viewDistance * viewDistance && particleID.equals("acidExhaust")) {
                particle = new EntityAcidExhaustFX((World)mc.field_71441_e, position.x, position.y, position.z, motion.x, motion.y, motion.z, 0.5f);
            }
            if (particle != null) {
                particle.field_70169_q = particle.field_70165_t;
                particle.field_70167_r = particle.field_70163_u;
                particle.field_70166_s = particle.field_70161_v;
                mc.field_71452_i.func_78873_a(particle);
            }
        }
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(6);
    }
}

