/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus;

import java.io.File;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigManagerVenus {
    public static boolean loaded;
    static Configuration config;
    public static int dimensionIDVenus;
    public static boolean disableAmbientLightning;
    public static boolean disableAluminumGen;
    public static boolean disableCopperGen;
    public static boolean disableGalenaGen;
    public static boolean disableQuartzGen;
    public static boolean disableSiliconGen;
    public static boolean disableTinGen;
    public static boolean disableSolarGen;

    public ConfigManagerVenus(File file) {
        if (!loaded) {
            if (file.exists()) {
                config = new Configuration(file);
                ConfigManagerVenus.syncConfig(true, true);
                file.delete();
                config = ConfigManagerMars.config;
            } else {
                config = ConfigManagerMars.config;
                ConfigManagerVenus.syncConfig(true, false);
            }
        }
    }

    public static void syncConfig(boolean load, boolean update) {
        try {
            if (!ConfigManagerVenus.config.isChild && update) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDVenus", -31);
            prop.comment = "Dimension ID for Venus";
            prop.setLanguageKey("gc.configgui.dimension_id_venus").setRequiresMcRestart(true);
            if (update) {
                Property propCopy = ConfigManagerMars.config.get("dimensions", prop.getName(), prop.getInt(), prop.comment);
                propCopy.setLanguageKey(prop.getLanguageKey());
                propCopy.setRequiresMcRestart(prop.requiresMcRestart());
            }
            dimensionIDVenus = prop.getInt();
            GalacticraftPlanets.finishProp(prop, "dimensions");
            boolean oldLightning = false;
            if (config.hasKey("schematic", "disableAmbientLightning")) {
                oldLightning = config.get("schematic", "disableAmbientLightning", false).getBoolean(false);
            }
            prop = config.get("general", "disableAmbientLightning", oldLightning);
            prop.comment = "Disable thunder and lightning on Venus.";
            prop.setLanguageKey("gc.configgui.disable_ambient_lightning");
            disableAmbientLightning = prop.getBoolean(oldLightning);
            GalacticraftPlanets.finishProp(prop, "general");
            prop = config.get("worldgen", "Disable Aluminum Ore Gen on Venus", false);
            prop.comment = "Disable Aluminum Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_aluminum_gen");
            disableAluminumGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Copper Ore Gen on Venus", false);
            prop.comment = "Disable Copper Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_copper_gen");
            disableCopperGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Galena Ore Gen on Venus", false);
            prop.comment = "Disable Galena Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_galena_gen");
            disableGalenaGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Quartz Ore Gen on Venus", false);
            prop.comment = "Disable Quartz Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_quartz_gen");
            disableQuartzGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Silicon Ore Gen on Venus", false);
            prop.comment = "Disable Silicon Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_silicon_gen");
            disableSiliconGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Tin Ore Gen on Venus", false);
            prop.comment = "Disable Tin Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_tin_gen");
            disableTinGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get("worldgen", "Disable Solar Ore Gen on Venus", false);
            prop.comment = "Disable Solar Ore Gen on Venus.";
            prop.setLanguageKey("gc.configgui.disable_venus_solar_gen");
            disableSolarGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Venus (Planets) has a problem loading its config", (Object[])new Object[0]);
        }
    }
}

