/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;

public class WorldGenTerraformTree
extends WorldGenerator {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final int metaWood;
    private final int metaLeaves;

    public WorldGenTerraformTree(boolean par1, ItemStack sapling) {
        this(par1, 4, 0, 0, false);
    }

    public WorldGenTerraformTree(boolean par1, int par2, int par3, int par4, boolean vines) {
        super(par1);
        this.minTreeHeight = par2;
        this.metaWood = par3;
        this.metaLeaves = par4;
        this.vinesGrow = vines;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            int l;
            int b0;
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                b0 = 1;
                if (j == position.func_177956_o()) {
                    b0 = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    b0 = 2;
                }
                for (int k = position.func_177958_n() - b0; k <= position.func_177958_n() + b0 && flag; ++k) {
                    for (l = position.func_177952_p() - b0; l <= position.func_177952_p() + b0 && flag; ++l) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, new BlockPos(k, j, l))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            Block block1 = worldIn.func_180495_p(down).func_177230_c();
            boolean isSoil = block1.canSustainPlant((IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < 256 - i - 1) {
                BlockPos blockpos1;
                int l1;
                int k1;
                int j1;
                int i1;
                block1.onPlantGrow(worldIn, down, position);
                b0 = 3;
                int b1 = 0;
                for (l = position.func_177956_o() - b0 + i; l <= position.func_177956_o() + i; ++l) {
                    i1 = l - (position.func_177956_o() + i);
                    j1 = b1 + 1 - i1 / 2;
                    for (k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            Block block;
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i1 == 0) || !(block = worldIn.func_180495_p(blockpos1 = new BlockPos(k1, l, i2)).func_177230_c()).isAir((IBlockAccess)worldIn, blockpos1) && !block.isLeaves((IBlockAccess)worldIn, blockpos1) && block.func_149688_o() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos1, Blocks.field_150362_t.func_176203_a(this.metaLeaves));
                        }
                    }
                }
                for (l = 0; l < i; ++l) {
                    BlockPos upN = position.func_177981_b(l);
                    Block block2 = worldIn.func_180495_p(upN).func_177230_c();
                    if (!block2.isAir((IBlockAccess)worldIn, upN) && !block2.isLeaves((IBlockAccess)worldIn, upN) && block2.func_149688_o() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(l), Blocks.field_150364_r.func_176203_a(this.metaWood));
                    if (!this.vinesGrow || l <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(-1, l, 0))) {
                        this.func_181647_a(worldIn, position.func_177982_a(-1, l, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(1, l, 0))) {
                        this.func_181647_a(worldIn, position.func_177982_a(1, l, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(0, l, -1))) {
                        this.func_181647_a(worldIn, position.func_177982_a(0, l, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(position.func_177982_a(0, l, 1))) continue;
                    this.func_181647_a(worldIn, position.func_177982_a(0, l, 1), BlockVine.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (l = position.func_177956_o() - 3 + i; l <= position.func_177956_o() + i; ++l) {
                        i1 = l - (position.func_177956_o() + i);
                        j1 = 2 - i1 / 2;
                        for (k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                            for (l1 = position.func_177952_p() - j1; l1 <= position.func_177952_p() + j1; ++l1) {
                                BlockPos blockpos3 = new BlockPos(k1, l, l1);
                                if (!worldIn.func_180495_p(blockpos3).func_177230_c().isLeaves((IBlockAccess)worldIn, blockpos3)) continue;
                                BlockPos blockpos4 = blockpos3.func_177976_e();
                                blockpos1 = blockpos3.func_177974_f();
                                BlockPos blockpos5 = blockpos3.func_177978_c();
                                BlockPos blockpos2 = blockpos3.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos4).func_177230_c().isAir((IBlockAccess)worldIn, blockpos4)) {
                                    this.func_181647_a(worldIn, blockpos4, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos1).func_177230_c().isAir((IBlockAccess)worldIn, blockpos1)) {
                                    this.func_181647_a(worldIn, blockpos1, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos5).func_177230_c().isAir((IBlockAccess)worldIn, blockpos5)) {
                                    this.func_181647_a(worldIn, blockpos5, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_180495_p(blockpos2).func_177230_c().isAir((IBlockAccess)worldIn, blockpos2)) continue;
                                this.func_181647_a(worldIn, blockpos2, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && i > 5) {
                        for (l = 0; l < 2; ++l) {
                            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - l) != 0) continue;
                                j1 = rand.nextInt(3);
                                this.func_181652_a(worldIn, rand.nextInt(3), position.func_177982_a(enumfacing.func_82601_c(), i - 5 + l, enumfacing.func_82599_e()), enumfacing);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_181647_a(World world, BlockPos pos, PropertyBool facing) {
        IBlockState iblockstate = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)facing, (Comparable)Boolean.valueOf(true));
        this.func_175903_a(world, pos, iblockstate);
        pos = pos.func_177977_b();
        for (int i = 4; world.func_180495_p(pos).func_177230_c().isAir((IBlockAccess)world, pos) && i > 0; --i) {
            this.func_175903_a(world, pos, iblockstate);
            pos = pos.func_177977_b();
        }
    }

    private void func_181652_a(World p_181652_1_, int p_181652_2_, BlockPos p_181652_3_, EnumFacing p_181652_4_) {
        this.func_175903_a(p_181652_1_, p_181652_3_, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(p_181652_2_)).func_177226_a((IProperty)BlockCocoa.field_176387_N, (Comparable)p_181652_4_));
    }

    protected boolean func_150523_a(Block p_150523_1_) {
        return p_150523_1_.func_149688_o() == Material.field_151579_a || p_150523_1_.func_149688_o() == Material.field_151584_j || p_150523_1_ == Blocks.field_150349_c || p_150523_1_ == Blocks.field_150346_d || p_150523_1_ == Blocks.field_150364_r || p_150523_1_ == Blocks.field_150363_s || p_150523_1_ == Blocks.field_150345_g || p_150523_1_ == Blocks.field_150395_bd;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir((IBlockAccess)world, pos) || state.func_177230_c().isLeaves((IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c());
    }
}

