/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.world.gen;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenCavernMars
extends MapGenBaseMeta {
    public void generate(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, ChunkPrimer primer) {
        int var6 = this.range;
        this.worldObj = par2World;
        this.rand.setSeed(par2World.func_72905_C());
        long var7 = this.rand.nextLong();
        long var9 = this.rand.nextLong();
        for (int var11 = par3 - var6; var11 <= par3 + var6; ++var11) {
            for (int var12 = par4 - var6; var12 <= par4 + var6; ++var12) {
                long var13 = (long)var11 * var7;
                long var15 = (long)var12 * var9;
                this.rand.setSeed(var13 ^ var15 ^ par2World.func_72905_C());
                this.recursiveGenerate(par2World, var11, var12, par3, par4, primer);
            }
        }
    }

    protected void recursiveGenerate(World par1World, int xChunkCoord, int zChunkCoord, int origXChunkCoord, int origZChunkCoord, ChunkPrimer primer) {
        if (this.rand.nextInt(100) == 0) {
            double xPos = xChunkCoord * 16 + this.rand.nextInt(16);
            double yPos = 25.0;
            double zPos = zChunkCoord * 16 + this.rand.nextInt(16);
            this.generateLargeCaveNode(this.rand.nextLong(), origXChunkCoord, origZChunkCoord, primer, xPos, 25.0, zPos);
        }
    }

    protected void generateLargeCaveNode(long par1, int origXChunkCoord, int origZChunkCoord, ChunkPrimer primer, double xPos, double yPos, double zPos) {
        this.generateCaveNode(par1, origXChunkCoord, origZChunkCoord, primer, xPos, yPos, zPos, 1.0f + this.rand.nextFloat() * 6.0f, 10.0f, 10.0f, -1, -1, 0.2);
    }

    protected void generateCaveNode(long par1, int origXChunkCoord, int origZChunkCoord, ChunkPrimer primer, double xPos, double yPos, double zPos, float par12, float par13, float par14, int par15, int par16, double heightMultiplier) {
        boolean var28;
        double var19 = origXChunkCoord * 16 + 8;
        double var21 = origZChunkCoord * 16 + 8;
        float var23 = 0.0f;
        float var24 = 0.0f;
        Random var25 = new Random(par1);
        if (par16 <= 0) {
            int var26 = this.range * 16 - 16;
            par16 = var26 - var25.nextInt(var26 / 4);
        }
        boolean var54 = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            var54 = true;
        }
        int var27 = var25.nextInt(par16 / 2) + par16 / 4;
        boolean bl = var28 = var25.nextInt(6) == 0;
        while (par15 < par16) {
            double caveWidth = 40.0;
            double caveHeight = 40.0 * heightMultiplier;
            par14 = var28 ? (par14 *= 0.92f) : (par14 *= 0.7f);
            par14 += var24 * 0.1f;
            par13 += var23 * 0.1f;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 2.0f;
            var23 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 4.0f;
            if (!var54 && par15 == var27 && par12 > 1.0f && par16 > 0) {
                return;
            }
            if (var54 || var25.nextInt(4) != 0) {
                double var35 = xPos - var19;
                double var37 = zPos - var21;
                double var39 = par16 - par15;
                double var41 = par12 + 2.0f + 16.0f;
                if (var35 * var35 + var37 * var37 - var39 * var39 > var41 * var41) {
                    return;
                }
                if (xPos >= var19 - 16.0 - 80.0 && zPos >= var21 - 16.0 - 80.0 && xPos <= var19 + 16.0 + 80.0 && zPos <= var21 + 16.0 + 80.0) {
                    double var51;
                    int var50;
                    double var46;
                    int var45;
                    int var42;
                    int caveMinX = MathHelper.func_76128_c((double)(xPos - 40.0)) - origXChunkCoord * 16 - 1;
                    int caveMaxX = MathHelper.func_76128_c((double)(xPos + 40.0)) - origXChunkCoord * 16 + 1;
                    int caveMinY = MathHelper.func_76128_c((double)(yPos - caveHeight)) - 1;
                    int caveMaxY = MathHelper.func_76128_c((double)(yPos + caveHeight)) + 1;
                    int caveMinZ = MathHelper.func_76128_c((double)(zPos - 40.0)) - origZChunkCoord * 16 - 1;
                    int caveMaxZ = MathHelper.func_76128_c((double)(zPos + 40.0)) - origZChunkCoord * 16 + 1;
                    if (caveMinX < 0) {
                        caveMinX = 0;
                    }
                    if (caveMaxX > 16) {
                        caveMaxX = 16;
                    }
                    if (caveMinY < 1) {
                        caveMinY = 1;
                    }
                    if (caveMaxY > 65) {
                        caveMaxY = 65;
                    }
                    if (caveMinZ < 0) {
                        caveMinZ = 0;
                    }
                    if (caveMaxZ > 16) {
                        caveMaxZ = 16;
                    }
                    boolean isBlockWater = false;
                    for (var42 = caveMinX; !isBlockWater && var42 < caveMaxX; ++var42) {
                        for (int var43 = caveMinZ; !isBlockWater && var43 < caveMaxZ; ++var43) {
                            for (int var44 = caveMaxY + 1; !isBlockWater && var44 >= caveMinY - 1; --var44) {
                                var45 = (var42 * 16 + var43) * 128 + var44;
                                if (var44 < 0 || var44 >= 128 || var44 == caveMinY - 1 || var42 == caveMinX || var42 == caveMaxX - 1 || var43 == caveMinZ || var43 == caveMaxZ - 1) continue;
                                var44 = caveMinY;
                            }
                        }
                    }
                    for (var42 = caveMinX; var42 < caveMaxX; ++var42) {
                        double var59 = ((double)(var42 + origXChunkCoord * 16) + 0.5 - xPos) / 40.0;
                        for (var45 = caveMinZ; var45 < caveMaxZ; ++var45) {
                            var46 = ((double)(var45 + origZChunkCoord * 16) + 0.5 - zPos) / 40.0;
                            if (!(var59 * var59 + var46 * var46 < 1.0)) continue;
                            for (var50 = caveMaxY - 1; var50 >= caveMinY; --var50) {
                                int coords;
                                Block block;
                                var51 = ((double)var50 + 0.5 - yPos) / caveHeight;
                                if (!(var59 * var59 + var51 * var51 + var46 * var46 < 1.0) || !(var51 > -0.7) || (block = primer.func_177858_a(coords = (var42 * 16 + var45) * 256 + var50).func_177230_c()) != MarsBlocks.marsBlock && block != MarsBlocks.blockSludge && block != MarsBlocks.vine) continue;
                                primer.func_177857_a(coords, Blocks.field_150350_a.func_176223_P());
                            }
                        }
                    }
                    for (var42 = caveMinX; var42 < caveMaxX; ++var42) {
                        double var59 = ((double)(var42 + origXChunkCoord * 16) + 0.5 - xPos) / 40.0;
                        for (var45 = caveMinZ; var45 < caveMaxZ; ++var45) {
                            var46 = ((double)(var45 + origZChunkCoord * 16) + 0.5 - zPos) / 40.0;
                            if (!(var59 * var59 + var46 * var46 < 1.0)) continue;
                            for (var50 = caveMaxY - 1; var50 >= caveMinY; --var50) {
                                var51 = ((double)var50 + 0.5 - yPos) / caveHeight;
                                if (!(var59 * var59 + var51 * var51 + var46 * var46 < 1.0) || !(var51 > -0.7)) continue;
                                Block block = primer.func_177856_a(var42, var50, var45).func_177230_c();
                                Block blockAbove = primer.func_177856_a(var42, var50 + 1, var45).func_177230_c();
                                Block blockBelow = primer.func_177856_a(var42, var50 - 1, var45).func_177230_c();
                                if (Blocks.field_150350_a != block) continue;
                                if (blockAbove == MarsBlocks.marsBlock && this.rand.nextInt(200) == 0) {
                                    int modifier = 0;
                                    while (Blocks.field_150350_a == block && var50 + modifier > 0) {
                                        primer.func_177855_a(var42, var50 + modifier, var45, MarsBlocks.vine.func_176203_a(Math.abs(modifier) % 3));
                                        block = primer.func_177856_a(var42, var50 + --modifier, var45).func_177230_c();
                                    }
                                    continue;
                                }
                                if (blockBelow != MarsBlocks.marsBlock || this.rand.nextInt(200) != 0) continue;
                                primer.func_177855_a(var42, var50, var45, MarsBlocks.blockSludge.func_176203_a(0));
                            }
                        }
                    }
                }
            }
            ++par15;
        }
    }
}

