/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMarsT2;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGasLiquefier
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandler,
IOxygenReceiver {
    private final int tankCapacity = 2000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank = new FluidTank(this.tankCapacity * 2);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank2 = new FluidTank(this.tankCapacity);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = -10;
    private ItemStack[] containingItems = new ItemStack[4];
    private int airProducts = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int gasTankType = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int fluidTankType = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int fluidTank2Type = -1;

    public TileEntityGasLiquefier() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.setTierGC(2);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.airProducts == -1) {
            this.airProducts = this.getAirProducts();
        }
        if (!this.field_145850_b.field_72995_K) {
            FluidStack currentLiquid;
            FluidStack currentgas = this.gasTank.getFluid();
            this.gasTankType = currentgas == null || currentgas.amount <= 0 ? -1 : this.getIdFromName(currentgas.getFluid().getName());
            if (this.airProducts == 0 && this.gasTankType == TankGases.AIR.index) {
                this.gasTank.drain(this.gasTank.getFluidAmount(), true);
            }
            this.fluidTankType = (currentLiquid = this.liquidTank.getFluid()) == null || currentLiquid.amount == 0 ? -1 : this.getProductIdFromName(currentLiquid.getFluid().getName());
            currentLiquid = this.liquidTank2.getFluid();
            this.fluidTank2Type = currentLiquid == null || currentLiquid.amount == 0 ? -1 : this.getProductIdFromName(currentLiquid.getFluid().getName());
            ItemStack inputCanister = this.containingItems[1];
            if (inputCanister != null) {
                if (inputCanister.func_77973_b() instanceof ItemAtmosphericValve && this.airProducts > 0) {
                    Block blockAbove;
                    if ((this.gasTankType == -1 || this.gasTankType == TankGases.AIR.index && this.gasTank.getFluid().amount < this.gasTank.getCapacity()) && (blockAbove = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c()) != null && blockAbove.func_149688_o() == Material.field_151579_a && blockAbove != GCBlocks.breatheableAir && blockAbove != GCBlocks.brightBreatheableAir) {
                        FluidStack gcAtmosphere = FluidRegistry.getFluidStack((String)TankGases.AIR.gas, (int)4);
                        this.gasTank.fill(gcAtmosphere, true);
                        this.gasTankType = TankGases.AIR.index;
                    }
                } else if (inputCanister.func_77973_b() instanceof ItemCanisterGeneric) {
                    int amount = 1001 - inputCanister.func_77952_i();
                    if (amount > 0) {
                        Item canisterType = inputCanister.func_77973_b();
                        FluidStack canisterGas = null;
                        int factor = 1;
                        if (this.gasTankType <= 0 && canisterType == AsteroidsItems.methaneCanister) {
                            this.gasTankType = TankGases.METHANE.index;
                            canisterGas = FluidRegistry.getFluidStack((String)TankGases.METHANE.gas, (int)amount);
                        }
                        if ((this.gasTankType == TankGases.OXYGEN.index || this.gasTankType == -1) && canisterType == AsteroidsItems.canisterLOX) {
                            this.gasTankType = TankGases.OXYGEN.index;
                            canisterGas = FluidRegistry.getFluidStack((String)TankGases.OXYGEN.gas, (int)(amount * 2));
                            factor = 2;
                        }
                        if ((this.gasTankType == TankGases.NITROGEN.index || this.gasTankType == -1) && canisterType == AsteroidsItems.canisterLN2) {
                            this.gasTankType = TankGases.NITROGEN.index;
                            canisterGas = FluidRegistry.getFluidStack((String)TankGases.NITROGEN.gas, (int)(amount * 2));
                            factor = 2;
                        }
                        if (canisterGas != null) {
                            int used = this.gasTank.fill(canisterGas, true) / factor;
                            this.containingItems[1] = used == amount ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(canisterType, 1, 1001 - amount + used);
                        }
                    }
                } else {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputCanister);
                    if (liquid != null && liquid.amount > 0) {
                        String inputName = FluidRegistry.getFluidName((FluidStack)liquid);
                        if (this.gasTankType <= 0 && inputName.contains("methane")) {
                            if (currentgas == null || currentgas.amount + liquid.amount <= this.gasTank.getCapacity()) {
                                FluidStack gcMethane = FluidRegistry.getFluidStack((String)TankGases.METHANE.gas, (int)liquid.amount);
                                this.gasTank.fill(gcMethane, true);
                                this.gasTankType = 0;
                                this.containingItems[1] = FluidUtil.getUsedContainer((ItemStack)inputCanister);
                            }
                        } else if ((this.gasTankType == TankGases.OXYGEN.index || this.gasTankType == -1) && inputName.contains("oxygen")) {
                            int tankedAmount = liquid.amount * (inputName.contains("liquid") ? 2 : 1);
                            if (currentgas == null || currentgas.amount + tankedAmount <= this.gasTank.getCapacity()) {
                                FluidStack gcgas = FluidRegistry.getFluidStack((String)TankGases.OXYGEN.gas, (int)tankedAmount);
                                this.gasTank.fill(gcgas, true);
                                this.gasTankType = TankGases.OXYGEN.index;
                                this.containingItems[1] = FluidUtil.getUsedContainer((ItemStack)inputCanister);
                            }
                        } else if ((this.gasTankType == TankGases.NITROGEN.index || this.gasTankType == -1) && inputName.contains("nitrogen")) {
                            int tankedAmount = liquid.amount * (inputName.contains("liquid") ? 2 : 1);
                            if (currentgas == null || currentgas.amount + tankedAmount <= this.gasTank.getCapacity()) {
                                FluidStack gcgas = FluidRegistry.getFluidStack((String)TankGases.NITROGEN.gas, (int)tankedAmount);
                                this.gasTank.fill(gcgas, true);
                                this.gasTankType = TankGases.NITROGEN.index;
                                this.containingItems[1] = FluidUtil.getUsedContainer((ItemStack)inputCanister);
                            }
                        }
                    }
                }
            }
            this.checkFluidTankTransfer(2, this.liquidTank);
            this.checkFluidTankTransfer(3, this.liquidTank2);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    this.processTimeRequired = Math.max(1, 4 - this.poweredByTierGC);
                }
                if (this.processTicks <= 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doLiquefaction();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else if (this.processTicks > 0) {
                this.processTicks = 0;
            } else if (--this.processTicks <= -10) {
                this.processTicks = -10;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (FluidUtil.isValidContainer((ItemStack)this.containingItems[slot])) {
            FluidStack liquid = tank.getFluid();
            if (liquid != null && liquid.amount > 0) {
                String liquidname = liquid.getFluid().getName();
                if (liquidname.startsWith("fuel")) {
                    FluidUtil.tryFillContainerFuel((FluidTank)tank, (ItemStack[])this.containingItems, (int)slot);
                } else if (liquidname.equals(TankGases.OXYGEN.liquid)) {
                    FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.canisterLOX);
                } else if (liquidname.equals(TankGases.NITROGEN.liquid)) {
                    FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.canisterLN2);
                }
            }
        } else if (this.containingItems[slot] != null && this.containingItems[slot].func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    public int getIdFromName(String gasname) {
        for (TankGases type : TankGases.values()) {
            if (!type.gas.equals(gasname)) continue;
            return type.index;
        }
        return -1;
    }

    public int getProductIdFromName(String gasname) {
        for (TankGases type : TankGases.values()) {
            if (!type.liquid.equals(gasname)) continue;
            return type.index;
        }
        return -1;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getFluid() != null ? this.gasTank.getFluid().amount * i / this.gasTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel2(int i) {
        return this.liquidTank2.getFluid() != null ? this.liquidTank2.getFluid().amount * i / this.liquidTank2.getCapacity() : 0;
    }

    public boolean canProcess() {
        boolean tank2HasSpace;
        if (this.gasTank.getFluid() == null || this.gasTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        if (this.fluidTankType == -1 || this.fluidTank2Type == -1) {
            return true;
        }
        boolean tank1HasSpace = this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
        boolean bl = tank2HasSpace = this.liquidTank2.getFluidAmount() < this.liquidTank2.getCapacity();
        if (this.gasTankType == TankGases.AIR.index) {
            int airProducts = this.airProducts;
            do {
                int thisProduct;
                if (((thisProduct = (airProducts & 0xF) - 1) != this.fluidTankType || !tank1HasSpace) && (thisProduct != this.fluidTank2Type || !tank2HasSpace)) continue;
                return true;
            } while ((airProducts >>= 4) > 0);
            return false;
        }
        return this.gasTankType == this.fluidTankType && tank1HasSpace || this.gasTankType == this.fluidTank2Type && tank2HasSpace;
    }

    public int getAirProducts() {
        WorldProvider WP = this.field_145850_b.field_73011_w;
        if (WP instanceof WorldProviderSpace) {
            int result = 0;
            ArrayList atmos = ((WorldProviderSpace)WP).getCelestialBody().atmosphere.composition;
            if (atmos.size() > 0) {
                result = this.getIdFromName(((EnumAtmosphericGas)atmos.get(0)).name().toLowerCase()) + 1;
            }
            if (atmos.size() > 1) {
                result += 16 * (this.getIdFromName(((EnumAtmosphericGas)atmos.get(1)).name().toLowerCase()) + 1);
            }
            if (atmos.size() > 2) {
                result += 256 * (this.getIdFromName(((EnumAtmosphericGas)atmos.get(2)).name().toLowerCase()) + 1);
            }
            return result;
        }
        return 35;
    }

    public void doLiquefaction() {
        int gasAmount = this.gasTank.getFluid().amount;
        if (gasAmount == 0) {
            return;
        }
        if (this.gasTankType == TankGases.AIR.index) {
            int airProducts = this.airProducts;
            int amountToDrain = Math.min(gasAmount / 2, airProducts > 15 ? 2 : 3);
            if (amountToDrain == 0) {
                amountToDrain = 1;
            }
            do {
                int thisProduct;
                if ((thisProduct = (airProducts & 0xF) - 1) >= 0) {
                    this.gasTank.drain(this.placeIntoFluidTanks(thisProduct, amountToDrain) * 2, true);
                }
                airProducts >>= 4;
                if ((amountToDrain >>= 1) != 0) continue;
                amountToDrain = 1;
            } while (airProducts > 0);
        } else if (gasAmount == 1) {
            this.gasTank.drain(this.placeIntoFluidTanks(this.gasTankType, 1), true);
        } else {
            this.gasTank.drain(this.placeIntoFluidTanks(this.gasTankType, Math.min(gasAmount / 2, 3)) * 2, true);
        }
    }

    private int placeIntoFluidTanks(int thisProduct, int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        int fuelSpace2 = this.liquidTank2.getCapacity() - this.liquidTank2.getFluidAmount();
        if ((thisProduct == this.fluidTank2Type || this.fluidTank2Type == -1) && fuelSpace2 > 0) {
            if (amountToDrain > fuelSpace2) {
                amountToDrain = fuelSpace2;
            }
            this.liquidTank2.fill(FluidRegistry.getFluidStack((String)TankGases.values()[thisProduct].liquid, (int)amountToDrain), true);
            this.fluidTank2Type = thisProduct;
        } else if ((thisProduct == this.fluidTankType || this.fluidTankType == -1) && fuelSpace > 0) {
            if (amountToDrain > fuelSpace) {
                amountToDrain = fuelSpace;
            }
            this.liquidTank.fill(FluidRegistry.getFluidStack((String)TankGases.values()[thisProduct].liquid, (int)amountToDrain), true);
            this.fluidTankType = thisProduct;
        } else {
            amountToDrain = 0;
        }
        return amountToDrain;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("liquidTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("liquidTank"));
        }
        if (nbt.func_74764_b("liquidTank2")) {
            this.liquidTank2.readFromNBT(nbt.func_74775_l("liquidTank2"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.gasTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("liquidTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank2.getFluid() != null) {
            nbt.func_74782_a("liquidTank2", (NBTBase)this.liquidTank2.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.mars_machine.4.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{0, 1, 2, 3};
        }
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        return new int[]{1, 2, 3};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemstack);
                }
                case 1: {
                    return FluidUtil.isMethaneContainerAny((ItemStack)itemstack);
                }
                case 2: {
                    return FluidUtil.isEmptyContainerFor((ItemStack)itemstack, (FluidStack)this.liquidTank.getFluid());
                }
                case 3: {
                    return FluidUtil.isEmptyContainerFor((ItemStack)itemstack, (FluidStack)this.liquidTank2.getFluid());
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack);
            }
            case 1: {
                return FluidUtil.isEmptyContainer((ItemStack)itemstack);
            }
            case 2: {
                return FluidUtil.isFullContainer((ItemStack)itemstack);
            }
            case 3: {
                return FluidUtil.isFullContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: 
            case 2: 
            case 3: {
                return FluidUtil.isValidContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public double getPacketRange() {
        return 320.0;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getGasInputDirection().func_176734_d()) {
            return this.liquidTank2.getFluid() != null && this.liquidTank2.getFluidAmount() > 0;
        }
        if (this.getGasInputDirection().func_176746_e() == from) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getGasInputDirection().func_176734_d() && resource != null && resource.isFluidEqual(this.liquidTank2.getFluid())) {
            return this.liquidTank2.drain(resource.amount, doDrain);
        }
        if (this.getGasInputDirection().func_176746_e() == from && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getGasInputDirection().func_176734_d()) {
            return this.liquidTank2.drain(maxDrain, doDrain);
        }
        if (this.getGasInputDirection().func_176746_e() == from) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from.equals((Object)this.getGasInputDirection())) {
            return fluid == null || this.getIdFromName(fluid.getName()) > -1;
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            int type = this.getIdFromName(FluidRegistry.getFluidName((FluidStack)resource));
            if (this.gasTankType == -1 || this.gasTankType == type && this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
                used = this.gasTank.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == this.getGasInputDirection()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
        } else if (from == this.getGasInputDirection().func_176734_d()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank2)};
        }
        if (this.getGasInputDirection().func_176746_e() == from) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        return this.func_145838_q().func_176201_c(this.field_145850_b.func_180495_p(this.func_174877_v())) & 3;
    }

    public boolean shouldPullOxygen() {
        return this.gasTankType == -1 || this.gasTankType == 1 && this.gasTank.getFluidAmount() < this.gasTank.getCapacity();
    }

    public int receiveOxygen(EnumFacing from, int receive, boolean doReceive) {
        if (from == this.getGasInputDirection() && this.shouldPullOxygen()) {
            float conversion = 0.18518518f;
            FluidStack fluidToFill = new FluidStack(AsteroidsModule.fluidOxygenGas, (int)((float)receive * conversion));
            int used = MathHelper.func_76123_f((float)((float)this.gasTank.fill(fluidToFill, doReceive) / conversion));
            return used;
        }
        return 0;
    }

    public int provideOxygen(EnumFacing from, int request, boolean doProvide) {
        return 0;
    }

    public int getOxygenRequest(EnumFacing direction) {
        return this.receiveOxygen(direction, 1000000, false);
    }

    public int getOxygenProvide(EnumFacing direction) {
        return 0;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getGasInputDirection() || direction == this.getGasInputDirection().func_176734_d() || direction == this.getGasInputDirection().func_176746_e();
        }
        if (type == NetworkType.POWER) {
            return direction == EnumFacing.DOWN;
        }
        return false;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineMarsT2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineMarsT2.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getGasInputDirection() {
        return this.getFront().func_176746_e();
    }

    public static enum TankGases {
        METHANE(0, "methane", ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel"),
        OXYGEN(1, "oxygen", "liquidoxygen"),
        NITROGEN(2, "nitrogen", "liquidnitrogen"),
        ARGON(3, "argon", "liquidargon"),
        AIR(4, "atmosphericgases", "xxyyzz");

        int index;
        String gas;
        String liquid;

        private TankGases(int id, String fluidname, String outputname) {
            this.index = id;
            this.gas = fluidname;
            this.liquid = outputname;
        }
    }
}

