/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.entities;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityTier2Rocket
extends EntityTieredRocket {
    public EntityTier2Rocket(World par1World) {
        super(par1World);
        this.func_70105_a(1.2f, 4.5f);
    }

    public EntityTier2Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.func_70105_a(1.2f, 4.5f);
    }

    public EntityTier2Rocket(World par1World, double par2, double par4, double par6, boolean reversed, IRocketType.EnumRocketType rocketType, ItemStack[] inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.cargoItems = inv;
    }

    public double func_70033_W() {
        return 1.5;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(MarsItems.rocketMars, 1, this.rocketType.getIndex());
    }

    public double func_70042_X() {
        return 1.6;
    }

    public float getRotateOffset() {
        return 1.25f;
    }

    public double getOnPadYOffset() {
        return -0.2;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                d = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d * 1.2, 1.8) : Math.min(d, 1.2);
                if (d != 0.0) {
                    this.field_70181_x = -d * 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
            if (this.cargoItems == null || this.cargoItems.length == 0) {
                stats.setRocketStacks(new ItemStack[2]);
            } else {
                stats.setRocketStacks(this.cargoItems);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setRocketItem(MarsItems.rocketMars);
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 2.9 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 2.9 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 2.9 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.min(Math.max(modifier, 80.0), 200.0);
                x1 *= modifier / 100.0;
                y1 *= modifier / 100.0;
                z1 *= modifier / 100.0;
            }
            double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - this.field_70181_x + (!this.getLaunched() ? 1.2 : 0.0);
            double x2 = this.field_70165_t + x1 - this.field_70159_w;
            double z2 = this.field_70161_v + z1 - this.field_70179_y;
            double x3 = x2 + x1 / 2.0;
            double y3 = y + y1 / 2.0;
            double z3 = z2 + z1 / 2.0;
            Vector3 motionVec = new Vector3(x1, y1, z1);
            if (this.field_70173_aa % 2 == 0 && !this.getLaunched()) {
                return;
            }
            String flame = this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle";
            Object[] rider = new Object[]{this.field_70153_n};
            Object[] none = new Object[]{};
            Random random = this.field_70146_Z;
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4 - random.nextDouble() / 10.0, y, z2 + 0.4 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4 + random.nextDouble() / 10.0, y, z2 + 0.4 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4 + random.nextDouble() / 10.0, y, z2 - 0.4 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4 - random.nextDouble() / 10.0, y, z2 - 0.4 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4, y, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4, y, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2 + 0.4), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2 - 0.4), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 8.0, y3 + 0.4, z3 + 0.2 - random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 8.0, y3 + 0.4, z3 + 0.2 - random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 8.0, y3 + 0.4, z3 - 0.2 + random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 8.0, y3 + 0.4, z3 - 0.2 + random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 8.0, y3 - 0.4, z3 + 0.2 - random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 8.0, y3 - 0.4, z3 + 0.2 - random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 8.0, y3 - 0.4, z3 - 0.2 + random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 8.0, y3 - 0.4, z3 - 0.2 + random.nextDouble() / 8.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 10.0, y3, z3 + 0.7 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 10.0, y3, z3 + 0.7 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 10.0, y3, z3 - 0.7 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 10.0, y3, z3 - 0.7 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 10.0, y3, z3 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 10.0, y3, z3 - random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + random.nextDouble() / 10.0, y3, z3 + 0.7 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - random.nextDouble() / 10.0, y3, z3 - 0.7 + random.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2 - 0.8, y, z2), motionVec, none);
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2 + 0.8, y, z2), motionVec, none);
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2, y, z2 - 0.8), motionVec, none);
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2, y, z2 + 0.8), motionVec, none);
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return !this.field_70128_L && par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }

    public int getRocketTier() {
        return 2;
    }

    public int getFuelTankCapacity() {
        return 1500;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(MarsItems.rocketMars, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public float getRenderOffsetY() {
        return -0.1f;
    }
}

