/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.client.nei.NEIGalacticraftMarsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GasLiquefierRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation liquefierGuiTexture = new ResourceLocation("galacticraftplanets", "textures/gui/gas_liquefier.png");
    private static final ResourceLocation liquefierGasesTexture = new ResourceLocation("galacticraftplanets", "textures/gui/gases_methane_oxygen_nitrogen.png");
    int ticksPassed;
    int extra = 0;
    int inputGas = 0;
    int outputGas = 0;
    boolean fillAtmos = false;
    protected FontRenderer fontRendererObj;

    public GasLiquefierRecipeHandler() {
        this.fontRendererObj = Minecraft.func_71410_x().field_71466_p;
    }

    public String getRecipeId() {
        return "galacticraft.liquefier";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<PositionedStack, PositionedStack>> getRecipes() {
        return NEIGalacticraftMarsConfig.getLiquefierRecipes();
    }

    public void drawBackground(int recipe) {
        int progress = this.ticksPassed % 144;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)liquefierGuiTexture);
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)4, (int)168, (int)64);
        if (progress <= 40) {
            if (this.fillAtmos) {
                int yoffset = progress / 3;
                GuiDraw.changeTexture((ResourceLocation)liquefierGasesTexture);
                GuiDraw.drawTexturedModalRect((int)2, (int)(62 - yoffset), (int)(1 + this.inputGas * 17), (int)(26 - yoffset), (int)16, (int)yoffset);
            } else if (this.inputGas > 0) {
                GuiDraw.changeTexture((ResourceLocation)liquefierGasesTexture);
                GuiDraw.drawTexturedModalRect((int)2, (int)52, (int)(1 + this.inputGas * 17), (int)16, (int)16, (int)10);
            }
        } else if (progress < 104) {
            int level = (progress - 41) / 3;
            int yoffset = 20 - level;
            if (this.fillAtmos) {
                yoffset = 13 + level / 3;
            }
            GuiDraw.changeTexture((ResourceLocation)liquefierGasesTexture);
            GuiDraw.drawTexturedModalRect((int)2, (int)(62 - yoffset), (int)(1 + this.inputGas * 17), (int)(26 - yoffset), (int)16, (int)yoffset);
            if (this.outputGas == 0) {
                GuiDraw.changeTexture((ResourceLocation)liquefierGuiTexture);
                GuiDraw.drawTexturedModalRect((int)127, (int)(62 - level), (int)192, (int)(26 - level), (int)16, (int)level);
            } else {
                GuiDraw.drawTexturedModalRect((int)(127 + (this.outputGas == 3 ? 21 : 0)), (int)(62 - level), (int)(1 + this.outputGas * 17), (int)(26 - level), (int)16, (int)level);
                GuiDraw.changeTexture((ResourceLocation)liquefierGuiTexture);
            }
            int powerlevel = 53 - (progress - 41) / 6;
            GuiDraw.drawTexturedModalRect((int)37, (int)13, (int)176, (int)38, (int)powerlevel, (int)7);
            GuiDraw.drawTexturedModalRect((int)23, (int)12, (int)208, (int)0, (int)11, (int)10);
        }
        if (this.fillAtmos) {
            String gasname = this.outputGas == 3 ? GCCoreUtil.translate((String)"gas.oxygen.name") : GCCoreUtil.translate((String)"gas.nitrogen.name");
            String text1 = " * " + GCCoreUtil.translate((String)"gui.message.with_atmosphere0.name");
            String text2 = GCCoreUtil.lowerCaseNoun((String)gasname) + " " + GCCoreUtil.translate((String)"gui.message.with_atmosphere1.name");
            this.fontRendererObj.func_78276_b(text1, 4, 83, 0x404040);
            this.fontRendererObj.func_78276_b(text2, 4, 93, 0x404040);
        }
    }

    public void onUpdate() {
        this.ticksPassed += 1 + this.extra;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedLiquefierRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedLiquefierRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)irecipe.getKey().item)) continue;
            this.arecipes.add(new CachedLiquefierRecipe(irecipe));
            break;
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        PositionedStack input = (PositionedStack)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients().get(0);
        Item inputItem = input.item.func_77973_b();
        this.inputGas = 2;
        this.fillAtmos = false;
        if (inputItem == AsteroidsItems.methaneCanister) {
            this.inputGas = 0;
        } else if (inputItem == AsteroidsItems.canisterLOX) {
            this.inputGas = 1;
        } else if (inputItem == AsteroidsItems.atmosphericValve) {
            this.fillAtmos = true;
        }
        if (this.ticksPassed % 144 > 40) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(new PositionedStack((Object)new ItemStack(inputItem, 1, inputItem.func_77612_l()), input.relx, input.rely));
            return stacks;
        }
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        PositionedStack output = ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        Item outputItem = output.item.func_77973_b();
        this.outputGas = outputItem == GCItems.fuelCanister ? 0 : (outputItem == AsteroidsItems.canisterLOX ? 3 : 4);
        if (this.ticksPassed % 144 < 104) {
            return new PositionedStack((Object)new ItemStack(outputItem, 1, outputItem.func_77612_l()), output.relx, output.rely);
        }
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    public String getRecipeName() {
        return GCCoreUtil.translate((String)"tile.mars_machine.4.name");
    }

    public String getGuiTexture() {
        return "galacticraftplanetstextures/gui/gas_liquefier.png";
    }

    public void drawForeground(int recipe) {
    }

    public class CachedLiquefierRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedLiquefierRecipe(PositionedStack pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)GasLiquefierRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedLiquefierRecipe(Map.Entry<PositionedStack, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

