/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachineMars
extends BlockTileGC
implements IShiftDescription,
ISortableBlock,
IPartialSealableBlock {
    public static final int TERRAFORMER_METADATA = 0;
    public static final int CRYOGENIC_CHAMBER_METADATA = 4;
    public static final int LAUNCH_CONTROLLER_METADATA = 8;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachineMars(String assetName) {
        super(GCBlocks.machine);
        this.func_149672_a(field_149777_j);
        this.func_149663_c(assetName);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity var9 = worldIn.func_175625_s(pos);
        if (var9 instanceof IMultiBlock) {
            ((IMultiBlock)var9).onDestroy(var9);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a((metadata & 0xC) + change), 3);
        switch (metadata & 0xC) {
            case 4: {
                BlockMulti.onPlacement((World)worldIn, (BlockPos)pos, (EntityLivingBase)placer, (Block)this);
                break;
            }
            case 8: {
                WorldUtil.markAdjacentPadForUpdate((World)worldIn, (BlockPos)pos);
                TileEntity var8 = worldIn.func_175625_s(pos);
                if (var8 instanceof IChunkLoader && !worldIn.field_72995_K && ConfigManagerMars.launchControllerChunkLoad && placer instanceof EntityPlayer) {
                    ((IChunkLoader)var8).setOwnerName(((EntityPlayer)placer).func_70005_c_());
                    ((IChunkLoader)var8).onTicketLoaded(ForgeChunkManager.requestTicket((Object)GalacticraftCore.instance, (World)var8.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL), true);
                    break;
                }
                if (!(var8 instanceof TileEntityLaunchController) || !(placer instanceof EntityPlayer)) break;
                ((TileEntityLaunchController)var8).setOwnerName(((EntityPlayer)placer).func_70005_c_());
            }
        }
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock((IBlockState)state, (World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)FACING)));
        return true;
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumMachineType type = (EnumMachineType)((Object)state.func_177229_b(TYPE));
        if (type == EnumMachineType.LAUNCH_CONTROLLER) {
            playerIn.openGui((Object)GalacticraftPlanets.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (type == EnumMachineType.CRYOGENIC_CHAMBER) {
            ((IMultiBlock)worldIn.func_175625_s(pos)).onActivated(playerIn);
            return true;
        }
        playerIn.openGui((Object)GalacticraftPlanets.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumMachineType type = (EnumMachineType)((Object)state.func_177229_b(TYPE));
        if (type == EnumMachineType.LAUNCH_CONTROLLER) {
            return new TileEntityLaunchController();
        }
        if (type == EnumMachineType.CRYOGENIC_CHAMBER) {
            return new TileEntityCryogenicChamber();
        }
        return new TileEntityTerraformer();
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.func_176201_c(world.func_180495_p(pos)) >= 8) {
            WorldUtil.markAdjacentPadForUpdate((World)world, (BlockPos)pos);
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public ItemStack getTerraformer() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getChamber() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getLaunchController() {
        return new ItemStack((Block)this, 1, 8);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getTerraformer());
        par3List.add(this.getChamber());
        par3List.add(this.getLaunchController());
    }

    public int func_180651_a(IBlockState state) {
        EnumMachineType type = (EnumMachineType)((Object)state.func_177229_b(TYPE));
        if (type == EnumMachineType.LAUNCH_CONTROLLER) {
            return 8;
        }
        if (type == EnumMachineType.CRYOGENIC_CHAMBER) {
            return 4;
        }
        return 0;
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, Entity player) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == EnumMachineType.CRYOGENIC_CHAMBER;
    }

    public BlockPos getBedSpawnPosition(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return pos.func_177984_a();
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCryogenicChamber) {
            ((TileEntityCryogenicChamber)tile).isOccupied = true;
        }
    }

    public EnumFacing getBedDirection(IBlockAccess world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
    }

    public String getShiftDescription(int meta) {
        switch (meta) {
            case 4: {
                return GCCoreUtil.translate((String)"tile.cryo_chamber.description");
            }
            case 8: {
                return GCCoreUtil.translate((String)"tile.launch_controller.description");
            }
            case 0: {
                return GCCoreUtil.translate((String)"tile.terraformer.description");
            }
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineType type = EnumMachineType.byMetadata((int)Math.floor((double)meta / 4.0));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMeta() * 4;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177229_b(TYPE) == EnumMachineType.CRYOGENIC_CHAMBER) {
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, 0.05 + rand.nextDouble() * 0.01, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, 0.05 + rand.nextDouble() * 0.01, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, 0.05 + rand.nextDouble() * 0.01, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)((float)pos.func_177956_o() + 2.9f), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, -0.05 - rand.nextDouble() * 0.01, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)((float)pos.func_177956_o() + 2.9f), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, -0.05 - rand.nextDouble() * 0.01, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("cryoFreeze", new Vector3((double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)((float)pos.func_177956_o() + 2.9f), (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4), new Vector3(0.0, -0.05 - rand.nextDouble() * 0.01, 0.0), new Object[0]);
        }
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return world.func_180495_p(pos).func_177229_b(TYPE) != EnumMachineType.CRYOGENIC_CHAMBER;
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        TERRAFORMER(0, "terraformer"),
        CRYOGENIC_CHAMBER(1, "cryogenic_chamber"),
        LAUNCH_CONTROLLER(2, "launch_controller");

        private final int meta;
        private final String name;

        private EnumMachineType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumMachineType byMetadata(int meta) {
            return EnumMachineType.values()[meta % 3];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

